/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.ncco.Action;
import java.util.Arrays;
import java.util.Collection;

public class StreamAction
extends JsonableBaseObject
implements Action {
    private static final String ACTION = "stream";
    private Collection<String> streamUrl;
    private Float level;
    private Boolean bargeIn;
    private Integer loop;

    StreamAction() {
    }

    private StreamAction(Builder builder) {
        this.streamUrl = builder.streamUrl;
        this.level = builder.level;
        this.bargeIn = builder.bargeIn;
        this.loop = builder.loop;
    }

    @Override
    public String getAction() {
        return ACTION;
    }

    @JsonProperty(value="streamUrl")
    public Collection<String> getStreamUrl() {
        return this.streamUrl;
    }

    @JsonProperty(value="level")
    public Float getLevel() {
        return this.level;
    }

    @JsonProperty(value="bargeIn")
    public Boolean getBargeIn() {
        return this.bargeIn;
    }

    @JsonProperty(value="loop")
    public Integer getLoop() {
        return this.loop;
    }

    public static Builder builder(Collection<String> streamUrl) {
        return new Builder(streamUrl);
    }

    public static Builder builder(String ... streamUrl) {
        return StreamAction.builder(Arrays.asList(streamUrl));
    }

    public static class Builder {
        private Collection<String> streamUrl;
        private Float level;
        private Boolean bargeIn;
        private Integer loop;

        Builder(Collection<String> streamUrl) {
            this.streamUrl = streamUrl;
        }

        public Builder streamUrl(Collection<String> streamUrl) {
            this.streamUrl = streamUrl;
            return this;
        }

        public Builder streamUrl(String ... streamUrl) {
            return this.streamUrl(Arrays.asList(streamUrl));
        }

        public Builder level(Float level) {
            this.level = level;
            return this;
        }

        public Builder bargeIn(Boolean bargeIn) {
            this.bargeIn = bargeIn;
            return this;
        }

        public Builder loop(Integer loop) {
            this.loop = loop;
            return this;
        }

        public StreamAction build() {
            return new StreamAction(this);
        }
    }
}

