/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.TextToSpeechLanguage;
import com.vonage.client.voice.ncco.Action;

public class TalkAction
extends JsonableBaseObject
implements Action {
    private static final String ACTION = "talk";
    private String text;
    private Boolean bargeIn;
    private Integer loop;
    private Integer style;
    private Float level;
    private TextToSpeechLanguage language;
    private Boolean premium;

    TalkAction() {
    }

    private TalkAction(Builder builder) {
        this.text = builder.text;
        this.bargeIn = builder.bargeIn;
        this.loop = builder.loop;
        this.level = builder.level;
        this.style = builder.style;
        this.language = builder.language;
        this.premium = builder.premium;
    }

    @Override
    public String getAction() {
        return ACTION;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="bargeIn")
    public Boolean getBargeIn() {
        return this.bargeIn;
    }

    @JsonProperty(value="loop")
    public Integer getLoop() {
        return this.loop;
    }

    @JsonProperty(value="level")
    public Float getLevel() {
        return this.level;
    }

    @JsonProperty(value="language")
    public TextToSpeechLanguage getLanguage() {
        return this.language;
    }

    @JsonProperty(value="style")
    public Integer getStyle() {
        return this.style;
    }

    @JsonProperty(value="premium")
    public Boolean getPremium() {
        return this.premium;
    }

    public static Builder builder(String text) {
        return new Builder(text);
    }

    public static class Builder {
        private String text;
        private Boolean bargeIn;
        private Boolean premium;
        private Integer loop;
        private Integer style;
        private Float level;
        private TextToSpeechLanguage language;

        Builder(String text) {
            this.text = text;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder bargeIn(Boolean bargeIn) {
            this.bargeIn = bargeIn;
            return this;
        }

        public Builder loop(Integer loop) {
            this.loop = loop;
            return this;
        }

        public Builder level(Float level) {
            this.level = level;
            return this;
        }

        public Builder language(TextToSpeechLanguage language) {
            this.language = language;
            return this;
        }

        public Builder style(Integer style) {
            this.style = style;
            return this;
        }

        public Builder premium(Boolean premium) {
            this.premium = premium;
            return this;
        }

        public TalkAction build() {
            return new TalkAction(this);
        }
    }
}

