/*
 *   Copyright 2024 Vonage
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Response object when querying a user's conversations.
 */
public class UserConversation extends Conversation {
	private BaseMember member;

	protected UserConversation() {}

	/**
	 * Basic metadata about the conversation membership.
	 * 
	 * @return The embedded member response, or {@code null} if absent.
	 */
	@JsonProperty("_embedded")
	public BaseMember getMember() {
		return member;
	}
}
