/*
 *   Copyright 2024 Vonage
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package com.vonage.client.incoming;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import java.util.Date;
import java.util.Map;

/**
 * @deprecated Use {@link com.vonage.client.voice.EventWebhook}.
 */
@Deprecated
public class NotifyEvent implements Jsonable {
    @JsonProperty(value = "conversation_uuid")
    private String conversationUuid;
    private Date timestamp;
    private Map<String, Object> payload;

    public String getConversationUuid() {
        return conversationUuid;
    }

    public void setConversationUuid(String conversationUuid) {
        this.conversationUuid = conversationUuid;
    }

    public Date getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, Object> getPayload() {
        return payload;
    }

    public void setPayload(Map<String, Object> payload) {
        this.payload = payload;
    }

    @Override
    public String toString() {
        return "NotifyEvent{" +
                "conversationUuid='" + conversationUuid + '\'' +
                ", timestamp=" + timestamp +
                ", payload=" + payload +
                '}';
    }

    public static NotifyEvent fromJson(String json) {
        return Jsonable.fromJson(json);
    }
}
