/*
 *   Copyright 2024 Vonage
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

/**
 * This package contains classes to support usage of the <a href=https://developer.vonage.com/api/video>Video API</a>.
 * <br>
 *
 * This API is a rewrite of the <a href=https://github.com/opentok/Opentok-Java-SDK>OpenTok Java SDK</a>.
 * You can use {@link com.vonage.client.video.VideoClient} in a similar way to the {@code OpenTok} class in the
 * OpenTok Java SDK, although some method and class names may differ slightly, as they have been rewritten to
 * be consistent with the rest of this SDK.
 * See <a href=OPENTOK_TO_VONAGE_MIGRATION.md>OPENTOK_TO_VONAGE_MIGRATION.md</a> for details.
 * <br>
 *
 * Learn more about the Video API and how to use this SDK from the
 * <a href=https://developer.vonage.com/video/server-sdks/java>Vonage Developer Portal</a>.
 *
 * @since 8.0.0-beta1
 */
package com.vonage.client.video;
