/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.common.HttpMethod;
import java.net.URI;
import java.util.UUID;

public final class Callback
extends JsonableBaseObject {
    private URI url;
    private String eventMask;
    private Params params;
    private HttpMethod method;

    Callback() {
    }

    Callback(Builder builder) {
        this.url = builder.url;
        this.eventMask = builder.eventMask;
        if (this.eventMask != null && (this.eventMask.length() > 200 || this.eventMask.trim().isEmpty())) {
            throw new IllegalArgumentException("Event mask must be between 1 and 200 characters");
        }
        this.method = builder.method;
        if (this.method != null && this.method != HttpMethod.POST && this.method != HttpMethod.GET) {
            throw new IllegalArgumentException("Callback HTTP method must be either POST or GET, not " + (Object)((Object)this.method));
        }
        this.params = builder.params;
    }

    @JsonProperty(value="url")
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="event_mask")
    public String getEventMask() {
        return this.eventMask;
    }

    @JsonProperty(value="params")
    public Params getParams() {
        return this.params;
    }

    @JsonProperty(value="method")
    public HttpMethod getMethod() {
        return this.method;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private URI url;
        private String eventMask;
        private HttpMethod method;
        private Params params;

        private Builder() {
        }

        private Params initParams() {
            if (this.params == null) {
                this.params = new Params();
            }
            return this.params;
        }

        public Builder url(String url) {
            this.url = URI.create(url);
            return this;
        }

        public Builder eventMask(String eventMask) {
            this.eventMask = eventMask;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.initParams().applicationId = UUID.fromString(applicationId);
            return this;
        }

        public Builder nccoUrl(String nccoUrl) {
            this.initParams().nccoUrl = URI.create(nccoUrl);
            return this;
        }

        public Callback build() {
            return new Callback(this);
        }
    }

    public static class Params
    extends JsonableBaseObject {
        private UUID applicationId;
        private URI nccoUrl;

        protected Params() {
        }

        @JsonProperty(value="applicationId")
        public UUID getApplicationId() {
            return this.applicationId;
        }

        @JsonProperty(value="ncco_url")
        public URI getNccoUrl() {
            return this.nccoUrl;
        }
    }
}

