/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.conversations.AudioEarmuffOffEvent;
import com.vonage.client.conversations.AudioEarmuffOnEvent;
import com.vonage.client.conversations.AudioMuteOffEvent;
import com.vonage.client.conversations.AudioMuteOnEvent;
import com.vonage.client.conversations.AudioPlayDoneEvent;
import com.vonage.client.conversations.AudioPlayEvent;
import com.vonage.client.conversations.AudioPlayStopEvent;
import com.vonage.client.conversations.AudioRecordEvent;
import com.vonage.client.conversations.AudioRecordStopEvent;
import com.vonage.client.conversations.AudioSayDoneEvent;
import com.vonage.client.conversations.AudioSayEvent;
import com.vonage.client.conversations.AudioSayStopEvent;
import com.vonage.client.conversations.BaseMember;
import com.vonage.client.conversations.ConversationUpdatedEvent;
import com.vonage.client.conversations.ConversationsClient;
import com.vonage.client.conversations.CustomEvent;
import com.vonage.client.conversations.EphemeralEvent;
import com.vonage.client.conversations.EventDeleteEvent;
import com.vonage.client.conversations.EventType;
import com.vonage.client.conversations.GenericEvent;
import com.vonage.client.conversations.MessageDeliveredEvent;
import com.vonage.client.conversations.MessageRejectedEvent;
import com.vonage.client.conversations.MessageSeenEvent;
import com.vonage.client.conversations.MessageSubmittedEvent;
import com.vonage.client.conversations.MessageUndeliverableEvent;
import com.vonage.client.users.User;
import java.time.Instant;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=GenericEvent.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=EventDeleteEvent.class, name="event:delete"), @JsonSubTypes.Type(value=ConversationUpdatedEvent.class, name="conversation:updated"), @JsonSubTypes.Type(value=MessageSeenEvent.class, name="message:seen"), @JsonSubTypes.Type(value=MessageSubmittedEvent.class, name="message:submitted"), @JsonSubTypes.Type(value=MessageDeliveredEvent.class, name="message:delivered"), @JsonSubTypes.Type(value=MessageUndeliverableEvent.class, name="message:undeliverable"), @JsonSubTypes.Type(value=MessageRejectedEvent.class, name="message:rejected"), @JsonSubTypes.Type(value=AudioPlayEvent.class, name="audio:play"), @JsonSubTypes.Type(value=AudioPlayStopEvent.class, name="audio:play:stop"), @JsonSubTypes.Type(value=AudioPlayDoneEvent.class, name="audio:play:done"), @JsonSubTypes.Type(value=AudioSayEvent.class, name="audio:say"), @JsonSubTypes.Type(value=AudioSayStopEvent.class, name="audio:say:stop"), @JsonSubTypes.Type(value=AudioSayDoneEvent.class, name="audio:say:done"), @JsonSubTypes.Type(value=AudioRecordEvent.class, name="audio:record"), @JsonSubTypes.Type(value=AudioRecordStopEvent.class, name="audio:record:stop"), @JsonSubTypes.Type(value=AudioMuteOnEvent.class, name="audio:mute:on"), @JsonSubTypes.Type(value=AudioMuteOffEvent.class, name="audio:mute:off"), @JsonSubTypes.Type(value=AudioEarmuffOnEvent.class, name="audio:earmuff:on"), @JsonSubTypes.Type(value=AudioEarmuffOffEvent.class, name="audio:earmuff:off"), @JsonSubTypes.Type(value=EphemeralEvent.class, name="ephemeral"), @JsonSubTypes.Type(value=CustomEvent.class, name="custom")})
public abstract class Event
extends JsonableBaseObject {
    @JsonIgnore
    String conversationId;
    @JsonProperty(value="type")
    EventType type;
    @JsonProperty(value="id")
    Integer id;
    @JsonProperty(value="from")
    String from;
    @JsonProperty(value="timestamp")
    Instant timestamp;
    @JsonProperty(value="_embedded")
    Embedded _embedded;

    protected Event() {
    }

    Event(Builder<?, ?> builder) {
        this.type = Objects.requireNonNull(((Builder)builder).type, "Event type is required.");
        this.from = ConversationsClient.validateMemberId(((Builder)builder).from);
    }

    public Integer getId() {
        return this.id;
    }

    public EventType getType() {
        return this.type;
    }

    public String getFrom() {
        return this.from;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    @JsonIgnore
    public User getFromUser() {
        return this._embedded != null ? this._embedded.fromUser : null;
    }

    @JsonIgnore
    public BaseMember getFromMember() {
        return this._embedded != null ? this._embedded.fromMember : null;
    }

    public static abstract class Builder<E extends Event, B extends Builder<? extends E, ? extends B>> {
        private final EventType type;
        private String from;

        protected Builder(EventType type) {
            this.type = type;
        }

        public B from(String from) {
            this.from = from;
            return (B)this;
        }

        public abstract E build();
    }

    private static class Embedded
    extends JsonableBaseObject {
        @JsonProperty(value="from_user")
        User fromUser;
        @JsonProperty(value="from_member")
        BaseMember fromMember;

        private Embedded() {
        }
    }
}

