/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.vonage.client.conversations.AbstractConversationsFilterRequest;
import com.vonage.client.conversations.EventType;
import java.util.Map;

public class ListEventsRequest
extends AbstractConversationsFilterRequest {
    private final Boolean excludeDeletedEvents;
    private final Integer startId;
    private final Integer endId;
    private final EventType eventType;

    ListEventsRequest(Builder builder) {
        super(builder);
        this.excludeDeletedEvents = builder.excludeDeletedEvents;
        this.startId = builder.startId;
        this.endId = builder.endId;
        this.eventType = builder.eventType;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        if (this.excludeDeletedEvents != null) {
            params.put("exclude_deleted_events", this.excludeDeletedEvents.toString());
        }
        if (this.startId != null) {
            params.put("start_id", String.valueOf(this.startId));
        }
        if (this.endId != null) {
            params.put("end_id", String.valueOf(this.endId));
        }
        if (this.eventType != null) {
            params.put("event_type", this.eventType.toString());
        }
        return params;
    }

    public Boolean getExcludeDeletedEvents() {
        return this.excludeDeletedEvents;
    }

    public Integer getStartId() {
        return this.startId;
    }

    public Integer getEndId() {
        return this.endId;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConversationsFilterRequest.Builder<ListEventsRequest, Builder> {
        private Boolean excludeDeletedEvents;
        private Integer startId;
        private Integer endId;
        private EventType eventType;

        Builder() {
        }

        public Builder excludeDeletedEvents(boolean excludeDeletedEvents) {
            this.excludeDeletedEvents = excludeDeletedEvents;
            return this;
        }

        public Builder startId(int startId) {
            this.startId = startId;
            return this;
        }

        public Builder endId(int endId) {
            this.endId = endId;
            return this;
        }

        public Builder eventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public ListEventsRequest build() {
            return new ListEventsRequest(this);
        }
    }
}

