/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.conversations.ConversationResourceRequestWrapper;
import com.vonage.client.conversations.MemberState;
import java.util.Objects;

public final class UpdateMemberRequest
extends ConversationResourceRequestWrapper
implements Jsonable {
    private final MemberState state;
    private final String from;
    @JsonProperty(value="reason")
    private final Reason reason;

    UpdateMemberRequest(Builder builder) {
        super(builder.conversationId, builder.memberId);
        this.state = Objects.requireNonNull(builder.state, "State is required.");
        switch (this.state) {
            case JOINED: 
            case LEFT: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid state: " + (Object)((Object)this.state));
            }
        }
        this.reason = builder.reason;
        if (this.reason != null && this.state != MemberState.LEFT) {
            throw new IllegalStateException("Reason is only applicable when leaving.");
        }
        this.from = builder.from;
    }

    @JsonProperty(value="state")
    public MemberState getState() {
        return this.state;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonIgnore
    public String getCode() {
        return this.reason != null ? this.reason.code : null;
    }

    @JsonIgnore
    public String getText() {
        return this.reason != null ? this.reason.text : null;
    }

    @JsonIgnore
    public String getConversationId() {
        return this.conversationId;
    }

    @JsonIgnore
    public String getMemberId() {
        return this.resourceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String conversationId;
        private String memberId;
        private String from;
        private MemberState state;
        private Reason reason;

        Builder() {
        }

        public Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public Builder state(MemberState state) {
            this.state = state;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder code(String code) {
            if (this.reason == null) {
                this.reason = new Reason();
            }
            this.reason.code = code;
            return this;
        }

        public Builder text(String text) {
            if (this.reason == null) {
                this.reason = new Reason();
            }
            this.reason.text = text;
            return this;
        }

        public UpdateMemberRequest build() {
            return new UpdateMemberRequest(this);
        }
    }

    static final class Reason
    extends JsonableBaseObject {
        @JsonProperty(value="code")
        String code;
        @JsonProperty(value="text")
        String text;

        Reason() {
        }
    }
}

