/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.meetings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.meetings.AvailableFeatures;
import com.vonage.client.meetings.CallbackUrls;
import com.vonage.client.meetings.InitialJoinOptions;
import com.vonage.client.meetings.JoinApprovalLevel;
import com.vonage.client.meetings.MeetingRoom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;

public class UpdateRoomRequest
implements Jsonable {
    @JsonIgnore
    UUID roomId;
    private final Boolean expireAfterUse;
    private final InitialJoinOptions initialJoinOptions;
    private final CallbackUrls callbackUrls;
    private final AvailableFeatures availableFeatures;
    private final JoinApprovalLevel joinApprovalLevel;
    private final UUID themeId;
    @JsonIgnore
    private final Instant expiresAt;

    UpdateRoomRequest(Builder builder) {
        this.expireAfterUse = builder.expireAfterUse;
        this.initialJoinOptions = builder.initialJoinOptions;
        this.callbackUrls = builder.callbackUrls;
        this.availableFeatures = builder.availableFeatures;
        this.joinApprovalLevel = builder.joinApprovalLevel;
        this.themeId = builder.themeId;
        this.expiresAt = builder.expiresAt;
        MeetingRoom.validateExpiresAtAndRoomType(this.expiresAt, null);
    }

    @JsonProperty(value="expire_after_use")
    public Boolean getExpireAfterUse() {
        return this.expireAfterUse;
    }

    @JsonProperty(value="initial_join_options")
    public InitialJoinOptions getInitialJoinOptions() {
        return this.initialJoinOptions;
    }

    @JsonProperty(value="callback_urls")
    public CallbackUrls getCallbackUrls() {
        return this.callbackUrls;
    }

    @JsonProperty(value="available_features")
    public AvailableFeatures getAvailableFeatures() {
        return this.availableFeatures;
    }

    @JsonProperty(value="theme_id")
    public UUID getThemeId() {
        return this.themeId;
    }

    @JsonProperty(value="join_approval_level")
    public JoinApprovalLevel getJoinApprovalLevel() {
        return this.joinApprovalLevel;
    }

    @JsonProperty(value="expires_at")
    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    @Override
    public String toJson() {
        return "{\"update_details\":" + Jsonable.super.toJson() + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean expireAfterUse;
        private InitialJoinOptions initialJoinOptions;
        private CallbackUrls callbackUrls;
        private AvailableFeatures availableFeatures;
        private JoinApprovalLevel joinApprovalLevel;
        private UUID themeId;
        private Instant expiresAt;

        Builder() {
        }

        public Builder expireAfterUse(Boolean expireAfterUse) {
            this.expireAfterUse = expireAfterUse;
            return this;
        }

        public Builder initialJoinOptions(InitialJoinOptions initialJoinOptions) {
            this.initialJoinOptions = initialJoinOptions;
            return this;
        }

        public Builder callbackUrls(CallbackUrls callbackUrls) {
            this.callbackUrls = callbackUrls;
            return this;
        }

        public Builder availableFeatures(AvailableFeatures availableFeatures) {
            this.availableFeatures = availableFeatures;
            return this;
        }

        public Builder themeId(UUID themeId) {
            this.themeId = themeId;
            return this;
        }

        public Builder joinApprovalLevel(JoinApprovalLevel joinApprovalLevel) {
            this.joinApprovalLevel = joinApprovalLevel;
            return this;
        }

        public Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt.truncatedTo(ChronoUnit.MILLIS);
            return this;
        }

        public UpdateRoomRequest build() {
            return new UpdateRoomRequest(this);
        }
    }
}

