/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.messenger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessageRequest;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.messenger.Category;
import com.vonage.client.messages.messenger.Messenger;
import com.vonage.client.messages.messenger.Tag;

public abstract class MessengerRequest
extends MessageRequest {
    protected final Messenger messenger;

    protected MessengerRequest(Builder<?, ?> builder, MessageType messageType) {
        super(builder, Channel.MESSENGER, messageType);
        this.messenger = Messenger.construct(builder.category, builder.tag);
    }

    @Override
    protected void validateSenderAndRecipient(String from, String to) {
        for (String id : new String[]{from, to}) {
            if (id == null || id.isEmpty()) {
                throw new IllegalArgumentException("ID cannot be empty");
            }
            if (id.length() <= 50) continue;
            throw new IllegalArgumentException("ID cannot be longer than 50 characters");
        }
    }

    @JsonProperty(value="messenger")
    public Messenger getMessenger() {
        return this.messenger;
    }

    protected static abstract class Builder<M extends MessengerRequest, B extends Builder<? extends M, ? extends B>>
    extends MessageRequest.Builder<M, B> {
        protected Tag tag;
        protected Category category;

        protected Builder() {
        }

        public B tag(Tag tag) {
            this.tag = tag;
            return (B)this;
        }

        public B category(Category category) {
            this.category = category;
            return (B)this;
        }
    }
}

