/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.viber;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.messages.viber.Action;
import com.vonage.client.messages.viber.Category;

public final class ViberService
extends JsonableBaseObject {
    private final Category category;
    private final Integer ttl;
    private final Integer duration;
    private final Integer fileSize;
    private final String type;
    private final Action action;

    private ViberService(Category category, Integer ttl, String type, Action action, Integer duration, Integer fileSize) {
        this.category = category;
        this.ttl = ttl;
        this.type = type;
        this.action = action;
        this.duration = duration;
        this.fileSize = fileSize;
    }

    static ViberService construct(Category category, Integer ttl, String type, Action action, Integer duration, Integer fileSize) {
        if (category == null && ttl == null && type == null && action == null && duration == null && fileSize == null) {
            return null;
        }
        if (ttl != null && (ttl < 30 || ttl > 259200)) {
            throw new IllegalArgumentException("Time-to-live (ttl) must be between 30 and 259200 seconds");
        }
        if (duration != null && (duration < 1 || duration > 600)) {
            throw new IllegalArgumentException("Duration must be between 1 and 600 seconds.");
        }
        if (fileSize != null && (fileSize < 1 || fileSize > 200)) {
            throw new IllegalArgumentException("File size must be between 1 and 200 MB.");
        }
        return new ViberService(category, ttl, type, action, duration, fileSize);
    }

    @JsonProperty(value="category")
    public Category getCategory() {
        return this.category;
    }

    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="action")
    public Action getAction() {
        return this.action;
    }

    @JsonProperty(value="duration")
    public Integer getDuration() {
        return this.duration;
    }

    @JsonProperty(value="file_size")
    public Integer getFileSize() {
        return this.fileSize;
    }
}

