/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.whatsapp.WhatsappRequest;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class WhatsappSingleProductRequest
extends WhatsappRequest {
    WhatsappSingleProductRequest(Builder builder) {
        super(builder, MessageType.CUSTOM);
        LinkedHashMap<String, String> action = new LinkedHashMap<String, String>(4);
        action.put("catalog_id", Objects.requireNonNull(builder.catalogId, "Catalog ID is required."));
        action.put("product_retailer_id", Objects.requireNonNull(builder.productRetailerId, "Product retailer ID is required."));
        LinkedHashMap<String, Object> interactive = new LinkedHashMap<String, Object>(8);
        interactive.put("type", "product");
        if (builder.bodyText != null) {
            interactive.put("body", Collections.singletonMap("text", builder.bodyText));
        }
        if (builder.footerText != null) {
            interactive.put("footer", Collections.singletonMap("text", builder.footerText));
        }
        interactive.put("action", action);
        this.custom.put("type", "interactive");
        this.custom.put("interactive", interactive);
    }

    @Override
    public Map<String, ?> getCustom() {
        return super.getCustom();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WhatsappRequest.Builder<WhatsappSingleProductRequest, Builder> {
        String bodyText;
        String footerText;
        String catalogId;
        String productRetailerId;

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder productRetailerId(String productRetailerId) {
            this.productRetailerId = productRetailerId;
            return this;
        }

        public Builder bodyText(String bodyText) {
            this.bodyText = bodyText;
            return this;
        }

        public Builder footerText(String footerText) {
            this.footerText = footerText;
            return this;
        }

        @Override
        public WhatsappSingleProductRequest build() {
            return new WhatsappSingleProductRequest(this);
        }
    }
}

