/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.QueryParamsRequest;
import com.vonage.client.numbers.BaseNumberRequest;
import com.vonage.client.numbers.SearchPattern;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

abstract class BaseNumbersFilter
implements QueryParamsRequest {
    private Integer index;
    private Integer size;
    private String pattern;
    private String country;
    private SearchPattern searchPattern;

    BaseNumbersFilter(Builder<?, ?> builder) {
        this.index = ((Builder)builder).index;
        if (this.index != null && this.index < 1) {
            throw new IllegalArgumentException("'index' must be positive.");
        }
        this.size = ((Builder)builder).size;
        if (this.size != null && (this.size < 1 || this.size > 100)) {
            throw new IllegalArgumentException("'size' must be between 1 and 100.");
        }
        if (((Builder)builder).country != null) {
            this.country = BaseNumberRequest.validateCountry(((Builder)builder).country);
        }
        this.pattern = ((Builder)builder).pattern;
        this.searchPattern = ((Builder)builder).searchPattern;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getCountry() {
        return this.country;
    }

    public String getPattern() {
        return this.pattern;
    }

    public SearchPattern getSearchPattern() {
        return this.searchPattern;
    }

    @Deprecated
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Deprecated
    public void setSize(Integer size) {
        this.size = size;
    }

    @Deprecated
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Deprecated
    public void setSearchPattern(SearchPattern searchPattern) {
        this.searchPattern = searchPattern;
    }

    public Map<String, String> makeParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(8);
        if (this.index != null) {
            params.put("index", this.index.toString());
        }
        if (this.size != null) {
            params.put("size", this.size.toString());
        }
        if (this.pattern != null) {
            params.put("pattern", this.pattern);
        }
        if (this.searchPattern != null) {
            params.put("search_pattern", Integer.toString(this.searchPattern.getValue()));
        }
        if (this.country != null) {
            params.put("country", this.country);
        }
        return params;
    }

    public static abstract class Builder<F extends BaseNumbersFilter, B extends Builder<F, B>> {
        private Integer index;
        private Integer size;
        private String pattern;
        private String country;
        private SearchPattern searchPattern;

        Builder() {
        }

        public B country(String country) {
            this.country = country;
            return (B)this;
        }

        public B index(int index) {
            this.index = index;
            return (B)this;
        }

        public B size(int size) {
            this.size = size;
            return (B)this;
        }

        public B pattern(SearchPattern strategy, String pattern) {
            this.searchPattern = Objects.requireNonNull(strategy, "Matching strategy is required.");
            this.pattern = Objects.requireNonNull(pattern, "Pattern is required");
            return (B)this;
        }

        public abstract F build();
    }
}

