/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.vonage.client.numbers.BaseNumberRequest;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class UpdateNumberRequest
extends BaseNumberRequest {
    private final UUID applicationId;
    private CallbackType voiceCallbackType;
    private URI moHttpUrl;
    private URI voiceStatusCallback;
    private String moSmppSysType;
    private String voiceCallbackValue;
    private String messagesCallbackValue;

    private UpdateNumberRequest(Builder builder) {
        super(builder.country, builder.msisdn);
        this.applicationId = builder.appId;
        this.moHttpUrl = builder.moHttpUrl;
        this.voiceStatusCallback = builder.voiceStatusCallback;
        this.moSmppSysType = builder.moSmppSysType;
        this.voiceCallbackType = builder.voiceCallbackType;
        this.voiceCallbackValue = builder.voiceCallbackValue;
    }

    @Deprecated
    public UpdateNumberRequest(String msisdn, String country) {
        this(UpdateNumberRequest.builder(msisdn, country));
    }

    public UUID getApplicationId() {
        return this.applicationId;
    }

    public String getMoHttpUrl() {
        return this.moHttpUrl != null ? this.moHttpUrl.toString() : null;
    }

    public String getMoSmppSysType() {
        return this.moSmppSysType;
    }

    public CallbackType getVoiceCallbackType() {
        return this.voiceCallbackType;
    }

    public String getVoiceCallbackValue() {
        return this.voiceCallbackValue;
    }

    public String getVoiceStatusCallback() {
        return this.voiceStatusCallback != null ? this.voiceStatusCallback.toString() : null;
    }

    @Deprecated
    public void setMoHttpUrl(String moHttpUrl) {
        this.moHttpUrl = URI.create(moHttpUrl);
    }

    @Deprecated
    public void setMoSmppSysType(String moSmppSysType) {
        this.moSmppSysType = moSmppSysType;
    }

    @Deprecated
    public void setVoiceCallbackType(CallbackType voiceCallbackType) {
        this.voiceCallbackType = voiceCallbackType;
    }

    @Deprecated
    public void setVoiceCallbackValue(String voiceCallbackValue) {
        this.voiceCallbackValue = voiceCallbackValue;
    }

    @Deprecated
    public void setVoiceStatusCallback(String voiceStatusCallback) {
        this.voiceStatusCallback = URI.create(voiceStatusCallback);
    }

    @Deprecated
    public String getMessagesCallbackValue() {
        return this.messagesCallbackValue;
    }

    @Deprecated
    public void setMessagesCallbackValue(String messagesCallbackValue) {
        this.messagesCallbackValue = messagesCallbackValue;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        if (this.applicationId != null) {
            params.put("app_id", this.applicationId.toString());
        }
        if (this.moHttpUrl != null) {
            params.put("moHttpUrl", this.moHttpUrl.toString());
        }
        if (this.moSmppSysType != null) {
            params.put("moSmppSysType", this.moSmppSysType);
        }
        if (this.voiceCallbackType != null) {
            params.put("voiceCallbackType", this.voiceCallbackType.toString());
        }
        if (this.voiceCallbackValue != null) {
            params.put("voiceCallbackValue", this.voiceCallbackValue);
        }
        if (this.voiceStatusCallback != null) {
            params.put("voiceStatusCallback", this.voiceStatusCallback.toString());
        }
        if (this.messagesCallbackValue != null) {
            params.put("messagesCallbackValue", this.messagesCallbackValue);
            params.put("messagesCallbackType", CallbackType.APP.paramValue());
        }
        return params;
    }

    public static Builder builder(String msisdn, String country) {
        return new Builder(msisdn, country);
    }

    public static class Builder {
        private final String country;
        private final String msisdn;
        private String moSmppSysType;
        private String voiceCallbackValue;
        private CallbackType voiceCallbackType;
        private UUID appId;
        private URI moHttpUrl;
        private URI voiceStatusCallback;

        private Builder(String msisdn, String country) {
            this.country = country;
            this.msisdn = msisdn;
        }

        public Builder moSmppSysType(String moSmppSysType) {
            this.moSmppSysType = moSmppSysType;
            return this;
        }

        public Builder voiceCallback(CallbackType type, String voiceCallbackValue) {
            this.voiceCallbackType = Objects.requireNonNull(type, "Voice callback type is required.)");
            this.voiceCallbackValue = Objects.requireNonNull(voiceCallbackValue, "Voice callback value is required.");
            return this;
        }

        public Builder applicationId(String appId) {
            return this.applicationId(UUID.fromString(appId));
        }

        public Builder applicationId(UUID appId) {
            this.appId = appId;
            return this;
        }

        public Builder moHttpUrl(String moHttpUrl) {
            return this.moHttpUrl(URI.create(moHttpUrl));
        }

        public Builder moHttpUrl(URI moHttpUrl) {
            this.moHttpUrl = moHttpUrl;
            return this;
        }

        public Builder voiceStatusCallback(String voiceStatusCallback) {
            return this.voiceStatusCallback(URI.create(voiceStatusCallback));
        }

        public Builder voiceStatusCallback(URI voiceStatusCallback) {
            this.voiceStatusCallback = voiceStatusCallback;
            return this;
        }

        public UpdateNumberRequest build() {
            return new UpdateNumberRequest(this);
        }
    }

    public static enum CallbackType {
        SIP,
        TEL,
        VXML,
        APP;


        @Deprecated
        public String paramValue() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static CallbackType fromString(String type) {
            if (type == null) {
                return null;
            }
            return CallbackType.valueOf(type.toUpperCase());
        }
    }
}

