/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.sms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MessageStatus {
    OK(0),
    THROTTLED(1),
    MISSING_PARAMS(2),
    INVALID_PARAMS(3),
    INVALID_CREDENTIALS(4),
    INTERNAL_ERROR(5),
    INVALID_MESSAGE(6),
    NUMBER_BARRED(7),
    PARTNER_ACCOUNT_BARRED(8),
    PARTNER_QUOTA_EXCEEDED(9),
    TOO_MANY_BINDS(10),
    ACCOUNT_NOT_HTTP(11),
    MESSAGE_TOO_LONG(12),
    COMMS_FAILURE(13),
    INVALID_SIGNATURE(14),
    INVALID_FROM_ADDRESS(15),
    INVALID_TTL(16),
    NUMBER_UNREACHABLE(17),
    TOO_MANY_DESTINATIONS(18),
    FACILITY_NOT_ALLOWED(19),
    INVALID_MESSAGE_CLASS(20),
    INVALID_NETWORK_CODE(22),
    INVALID_CALLBACK(23),
    NON_WHITELISTED_DESTINATION(29),
    SIGNATURE_API_SECRET_DISALLOWED(32),
    NUMBER_DEACTIVATED(33),
    UNKNOWN(Integer.MAX_VALUE);

    private final int messageStatus;
    private static final Map<Integer, MessageStatus> MESSAGE_STATUS_INDEX;

    @JsonCreator
    public static MessageStatus fromInt(int messageStatus) {
        return MESSAGE_STATUS_INDEX.getOrDefault(messageStatus, UNKNOWN);
    }

    private MessageStatus(int messageStatus) {
        this.messageStatus = messageStatus;
    }

    @JsonValue
    public int getMessageStatus() {
        return this.messageStatus;
    }

    static {
        MESSAGE_STATUS_INDEX = Arrays.stream(MessageStatus.values()).collect(Collectors.toMap(MessageStatus::getMessageStatus, Function.identity()));
    }
}

