/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.sms.messages;

import com.vonage.client.sms.messages.Message;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class BinaryMessage
extends Message {
    private final byte[] messageBody;
    private final byte[] udh;
    private int protocolId = 0;

    public BinaryMessage(String from, String to, byte[] messageBody, byte[] udh) {
        super(Message.MessageType.BINARY, from, to);
        this.messageBody = messageBody;
        this.udh = udh;
    }

    public byte[] getMessageBody() {
        return this.messageBody == null ? null : (byte[])this.messageBody.clone();
    }

    public byte[] getUdh() {
        return this.udh == null ? null : (byte[])this.udh.clone();
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(int protocolId) {
        this.protocolId = protocolId;
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        params.put("udh", Hex.encodeHexString((byte[])this.getUdh()));
        params.put("body", Hex.encodeHexString((byte[])this.getMessageBody()));
        params.put("protocol-id", Integer.toString(this.getProtocolId()));
        return params;
    }
}

