/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.subaccounts;

import com.vonage.client.QueryParamsRequest;
import com.vonage.client.subaccounts.AbstractTransfer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;

public class ListTransfersFilter
implements QueryParamsRequest {
    private final Instant startDate;
    private final Instant endDate;
    private final String subaccount;

    ListTransfersFilter(Builder builder) {
        this.startDate = builder.startDate != null ? builder.startDate : Instant.EPOCH;
        this.endDate = builder.endDate;
        this.subaccount = builder.subaccount;
        if (this.subaccount != null) {
            AbstractTransfer.validateAccountKey(builder.subaccount, "Subaccount");
        }
    }

    private static String formatTime(Instant timestamp) {
        return timestamp.truncatedTo(ChronoUnit.SECONDS).toString();
    }

    public Map<String, String> makeParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(4);
        params.put("start_date", ListTransfersFilter.formatTime(this.startDate));
        if (this.endDate != null) {
            params.put("end_date", ListTransfersFilter.formatTime(this.endDate));
        }
        if (this.subaccount != null) {
            params.put("subaccount", this.subaccount);
        }
        return params;
    }

    public Instant getStartDate() {
        return this.startDate;
    }

    public Instant getEndDate() {
        return this.endDate;
    }

    public String getSubaccount() {
        return this.subaccount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Instant startDate;
        private Instant endDate;
        private String subaccount;

        Builder() {
        }

        public Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder subaccount(String subaccount) {
            this.subaccount = subaccount;
            return this;
        }

        public ListTransfersFilter build() {
            return new ListTransfersFilter(this);
        }
    }
}

