/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.Endpoint;
import com.vonage.client.voice.EndpointType;
import com.vonage.client.voice.SipHeader;
import java.util.Collections;
import java.util.Map;

public class SipEndpoint
extends JsonableBaseObject
implements Endpoint {
    private String uri;
    private Map<String, ?> headers;
    private Map<SipHeader, String> standardHeaders;

    protected SipEndpoint() {
    }

    public SipEndpoint(String uri) {
        this(uri, null, null);
    }

    public SipEndpoint(String uri, String userToUserHeader) {
        this(uri, null, userToUserHeader);
    }

    public SipEndpoint(String uri, Map<String, ?> headers) {
        this(uri, headers, null);
    }

    public SipEndpoint(String uri, Map<String, ?> headers, String userToUserHeader) {
        this.uri = uri;
        this.headers = headers;
        if (userToUserHeader != null) {
            this.standardHeaders = Collections.singletonMap(SipHeader.USER_TO_USER, userToUserHeader);
        }
    }

    @JsonProperty(value="uri")
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getType() {
        return EndpointType.SIP.toString();
    }

    @JsonProperty(value="headers")
    public Map<String, ?> getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="standard_headers")
    public Map<SipHeader, String> getStandardHeaders() {
        return this.standardHeaders;
    }

    @Override
    public String toLog() {
        return this.uri;
    }
}

