/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.voice.EndpointType;
import com.vonage.client.voice.ncco.Endpoint;
import java.net.URI;
import java.util.Map;

public class WebSocketEndpoint
extends JsonableBaseObject
implements Endpoint {
    private final URI uri;
    private final String contentType;
    private final Map<String, ?> headers;

    private WebSocketEndpoint(Builder builder) {
        this.uri = builder.uri;
        this.contentType = builder.contentType;
        this.headers = builder.headers;
    }

    @JsonProperty(value="uri")
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getType() {
        return EndpointType.WEBSOCKET.toString();
    }

    @JsonProperty(value="content-type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="headers")
    public Map<String, ?> getHeaders() {
        return this.headers;
    }

    public static Builder builder(String uri, String contentType) {
        return new Builder(uri, contentType);
    }

    public static class Builder {
        private URI uri;
        private String contentType;
        private Map<String, ?> headers;

        Builder(String uri, String contentType) {
            this.uri = URI.create(uri);
            this.contentType = contentType;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder uri(String uri) {
            return this.uri(URI.create(uri));
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder headers(Map<String, ?> headers) {
            this.headers = headers;
            return this;
        }

        public WebSocketEndpoint build() {
            return new WebSocketEndpoint(this);
        }
    }
}

