/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.webrtc;

import androidx.annotation.Nullable;
import com.vonage.webrtc.Logging;
import com.vonage.webrtc.VideoCodecInfo;
import com.vonage.webrtc.VideoEncoder;
import com.vonage.webrtc.VideoEncoderFactory;
import com.vonage.webrtc.WrappedNativeVideoEncoder;
import java.util.List;

public class SoftwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "SoftwareVideoEncoderFactory";
    private final long nativeFactory = SoftwareVideoEncoderFactory.nativeCreateFactory();

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        final long nativeEncoder = SoftwareVideoEncoderFactory.nativeCreateEncoder(this.nativeFactory, info);
        if (nativeEncoder == 0L) {
            Logging.w(TAG, "Trying to create encoder for unsupported format. " + info);
            return null;
        }
        return new WrappedNativeVideoEncoder(){

            @Override
            public long createNativeVideoEncoder() {
                return nativeEncoder;
            }

            @Override
            public boolean isHardwareEncoder() {
                return false;
            }
        };
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoEncoderFactory.nativeGetSupportedCodecs(this.nativeFactory).toArray(new VideoCodecInfo[0]);
    }

    private static native long nativeCreateFactory();

    private static native long nativeCreateEncoder(long var0, VideoCodecInfo var2);

    private static native List<VideoCodecInfo> nativeGetSupportedCodecs(long var0);
}

