#ifndef MODULES_VONAGE_API_AUDIO_CODECS_VONAGE_AUDIO_ENCODING_DECODING_ENGINE_H_
#define MODULES_VONAGE_API_AUDIO_CODECS_VONAGE_AUDIO_ENCODING_DECODING_ENGINE_H_

#include <string>
#include <vector>

#include "api/audio_codecs/audio_encoder_factory.h"
#include "api/audio_codecs/audio_decoder_factory.h"
#include "api/scoped_refptr.h"

namespace vonage {

class VGAudioEncoderFactory : public webrtc::AudioEncoderFactory {
public:
    static rtc::scoped_refptr<webrtc::AudioEncoderFactory> Create(const std::vector<std::string>& preferred_codecs);
    ~VGAudioEncoderFactory() = default;

    std::vector<webrtc::AudioCodecSpec> GetSupportedEncoders() override;
    absl::optional<webrtc::AudioCodecInfo> QueryAudioEncoder(const webrtc::SdpAudioFormat& format) override;
    std::unique_ptr<webrtc::AudioEncoder> MakeAudioEncoder(int payload_type,
                                                           const webrtc::SdpAudioFormat& format,
                                                           absl::optional<webrtc::AudioCodecPairId> codec_pair_id) override;

protected:
    VGAudioEncoderFactory(const std::vector<std::string>& preferred_codecs);

private:
    void CodecStringToFormat(const std::vector<std::string> preferred_codecs);
    bool IsFormatInFormatList(const webrtc::SdpAudioFormat& format) const;

    rtc::scoped_refptr<webrtc::AudioEncoderFactory> inner_factory_;
    std::vector<webrtc::SdpAudioFormat> preferred_formats_;
};

class VGAudioDecoderFactory {
public:
    static rtc::scoped_refptr<webrtc::AudioDecoderFactory> Create();
};

}

#endif // MODULES_VONAGE_API_AUDIO_CODECS_VONAGE_AUDIO_ENCODING_DECODING_ENGINE_H_
