/** @file vonage_sframe_observer.h
    @brief Vonage SFrame Observer for E2EE.

    This file includes some oberver class implementation used along with encrytor and decryptor instances.
    It implements an simple mechanism for reporting events and messages originated from encrytor and decryptor instances.
*/
#ifndef MODULES_VONAGE_API_CRYPTO_SFRAME_VONAGE_SFRAME_OBSERVER_H
#define MODULES_VONAGE_API_CRYPTO_SFRAME_VONAGE_SFRAME_OBSERVER_H
#include <string>
#include "absl/base/attributes.h"
#include "modules/vonage/api/helpers/thread_wrapper.h"

namespace rtc{
class Thread;
}


namespace vonage {

class SFrameFrameEncryptionObserver {
public:
    enum class CodecType {
       kUnknown = 0,
       kOpus = 1,
       kVP8 = 2,
       kH264 = 3,
       kVP9 = 4,
       kH265 = 5,
       kAV1 = 6
    };

    /** Success code enumeration.
            This enumeration lists all possible success codes.
     */
    enum class SuccessCode {
        kGenericSuccess,
        kDecryptSuccess,
        kEncryptSuccess,
        kNone,
    };
    /** Error code enumeration.
            This enumeration lists all possible error codes.
     */
    enum class ErrorCode {
        kFailedToEncrypt,
        kFailedToDecrypt,
        kFailedToAuthenticate,
        kUnsupportedMediaCodec,
        kGenericError,
        kNone,
    };
    /** Warning code enumeration.
            This enumeration lists all possible warning codes.
     */
    enum class WarningCode {
        kMediaMightNotBeRendered,
        kGenericWarning,
        kNone,
    };

    /** SFrameFrameEncryptionObserver constructor.

        Constructor.
        @param observer_thread Thread where the observer will post the messages and events.
     */
    SFrameFrameEncryptionObserver(vonage::ThreadWrapper* observer_thread);
    SFrameFrameEncryptionObserver(rtc::Thread* observer_thread);
    virtual ~SFrameFrameEncryptionObserver();

    // Note: The developer should not call the three methods below.
    void ProxyOnSucess(SuccessCode code);
    void ProxyOnSucess(SuccessCode code, CodecType codec);
    void ProxyOnError(ErrorCode code, const std::string& message);
    void ProxyOnError(ErrorCode code, const std::string& message, CodecType codec);
    void ProxyOnWarning(WarningCode code, const std::string& message, CodecType codec);
    void EnableOnSuccess(bool enable);

    // Note: The developer should implement the three methods below according to the application needs.
    virtual void OnSuccess(SuccessCode code) = 0;
    virtual void OnSuccess(SuccessCode code, CodecType codec);
    virtual void OnWarning(WarningCode code, const std::string& message, CodecType codec);
    virtual void OnError(ErrorCode code, const std::string& message) = 0;
    virtual void OnError(ErrorCode code, const std::string& message, CodecType codec);

private:
    vonage::ThreadWrapper* observer_thread_;
    bool enable_on_success_;
    bool owns_thread_instance_;
};

} // namespace vonage

#endif // MODULES_VONAGE_API_CRYPTO_SFRAME_VONAGE_SFRAME_OBSERVER_H
