#pragma once

#include <string>

#include "absl/base/attributes.h"

#include "media_processor_status_code.h"


namespace webrtc {
class BaseFrameTransformerObserver;
class MediaProcessorStatus final {
public:
    MediaProcessorStatus() = default;
    MediaProcessorStatus(uint8_t code, const std::string& message);

#if VONAGE_WEBRTC_VERSION != 121    
    ABSL_DEPRECATED("Use MediaProcessorStatus(uint8_t code, const std::string& message) instead")
    MediaProcessorStatus(MediaProcessorWarningCode warning, const std::string& message);
    ABSL_DEPRECATED("Use MediaProcessorStatus(uint8_t code, const std::string& message) instead")
    MediaProcessorStatus(MediaProcessorErrorCode error, const std::string& message);
#endif
    
    virtual ~MediaProcessorStatus() = default;

#if VONAGE_WEBRTC_VERSION != 121     
    ABSL_DEPRECATED("Do not use it")
    bool ok() const;
    ABSL_DEPRECATED("Use either ReportError() or ReportWarning() instead")
    void report(BaseFrameTransformerObserver* observer) const;
#endif

    void ReportError(BaseFrameTransformerObserver* observer) const;
    void ReportWarning(BaseFrameTransformerObserver* observer) const;

private:
    uint8_t code_ = 0;
    std::string message_;
};
}
