#ifndef MODULES_VONAGE_API_ML_TRANSFORMERS_ML_TRANSFORMERS_H_
#define MODULES_VONAGE_API_ML_TRANSFORMERS_ML_TRANSFORMERS_H_

#include <functional>

#if defined(WEBRTC_MAC) || defined(WEBRTC_IOS)
#import <CoreVideo/CoreVideo.h>
#endif

#include "modules/vonage/api/media_processor/media_processor.h"

namespace webrtc {
class AudioFrame;
class VideoFrame;
}

namespace vonage {

const uint8_t g_process_error_code_ = 107;

/** Vonage audio transformer helper class with factory function.

 */
class VonageAudioTransformer {
public:
    enum class ReturnCode {
        kSuccess = 0,
        kWarning = 1,
        kError = 2
    };
    using GetRemixAndResampleConfig = std::function<uint8_t(size_t& num_channels,
                                                            int& sample_rate_hz,
                                                            bool& internal_resample_supported)>;
    using Transform = std::function<uint8_t(const int16_t* in_data,
                                            size_t samples_per_channel,
                                            size_t num_channels,
                                            int sample_rate_hz,
                                            int16_t* out_data,
                                            size_t* out_data_len,
                                            size_t out_data_max_len)>;
    using SetAudioOptions = std::function<uint8_t(bool echo_cancellation,
                                                  bool auto_gain_control,
                                                  bool noise_suppression,
                                                  bool stereo_swapping,
                                                  bool highpass_filter)>;
    using StatusReturnValue = const std::pair<uint8_t, std::string>&;                                                  
    using GetLastWarning = std::function<StatusReturnValue()>;
    using GetLastError = std::function<StatusReturnValue()>;

    /** Create factory function.

     Creates an audio transformer instance.
     */
    static std::shared_ptr<webrtc::BaseFrameTransformer<webrtc::AudioFrame>> Create(GetRemixAndResampleConfig get_remix_and_resample_config,
                                                                                    Transform transform,
                                                                                    SetAudioOptions set_audio_options,
                                                                                    GetLastWarning get_last_warning,
                                                                                    GetLastError get_last_error,
                                                                                    webrtc::BaseFrameTransformerObserver* observer);
};

/** Vonage video transformer helper class with factory function.

 */
class VonageVideoTransformer {
public:
    enum class ReturnCode {
        kSuccess = 0,
        kWarning = 1,
        kError = 2
    };
    using Transform = std::function<uint8_t(int with, int height,
                                            uint8_t* data_y, int stride_y,
                                            uint8_t* data_u, int stride_u,
                                            uint8_t* data_v, int stride_v,
                                            int rotation,
                                            uint64_t timestamp_us)>;
#if defined(WEBRTC_MAC) || defined(WEBRTC_IOS)
    using AppleTransform = std::function<uint8_t(CVPixelBufferRef buffer,
                                                 int rotation,
                                                 uint64_t timestamp_us)>;
#endif
    using StatusReturnValue = const std::pair<uint8_t, std::string>&;
    using GetLastWarning = std::function<StatusReturnValue()>;
    using GetLastError = std::function<StatusReturnValue()>;

    /** Create factory function.

     Creates a video transformer instance.
     */
    static std::shared_ptr<webrtc::BaseFrameTransformer<webrtc::VideoFrame>> Create(Transform transform,
#if defined(WEBRTC_MAC) || defined(WEBRTC_IOS)
                                                                                    AppleTransform apple_transform,
#endif
                                                                                    GetLastWarning get_last_warning,
                                                                                    GetLastError get_last_error,
                                                                                    webrtc::BaseFrameTransformerObserver* observer);
};

}

#endif // MODULES_VONAGE_API_ML_TRANSFORMERS_ML_TRANSFORMERS_H_

