#ifndef MODULES_VONAGE_API_VIDEO_IN_VIDEO_FRAME_AUGMENTED_DATA_H_
#define MODULES_VONAGE_API_VIDEO_IN_VIDEO_FRAME_AUGMENTED_DATA_H_

#include <vector>

#include "api/array_view.h"

namespace webrtc {

class RTC_EXPORT InVideoFrameAugmentedData final {
public:
    // Max size in bytes of augmented data attached to each instance.
    static constexpr size_t kMaxInVideoFrameAugmentedDataSizeBytes = 32;

    InVideoFrameAugmentedData();
    InVideoFrameAugmentedData(rtc::ArrayView<const uint8_t> data);

    ~InVideoFrameAugmentedData();

    // Support move and copy.
    InVideoFrameAugmentedData(const InVideoFrameAugmentedData&);
    InVideoFrameAugmentedData(InVideoFrameAugmentedData&&);
    InVideoFrameAugmentedData& operator=(const InVideoFrameAugmentedData&);
    InVideoFrameAugmentedData& operator=(InVideoFrameAugmentedData&&);

    bool SetInVideoFrameAugmentedData(rtc::ArrayView<const uint8_t> data);
    rtc::ArrayView<const uint8_t> GetInVideoFrameAugmentedData() const;

private:
    bool SetInVideoFrameAugmentedDataInternal(rtc::ArrayView<const uint8_t> data);

    // Note: This buffer will be placed in the Vonage in-video-frame augmented
    // data RTP header extensions.
    std::vector<uint8_t> in_video_frame_augmented_data_;
};

} // namespace webrtc

#endif // MODULES_VONAGE_API_VIDEO_IN_VIDEO_FRAME_AUGMENTED_DATA_H_
