#pragma once

#include <string>
#include <vector>

#include "api/video_codecs/video_encoder.h"
#include "api/video_codecs/video_encoder_factory.h"
#include "api/video_codecs/video_decoder_factory.h"

namespace vonage {

class VGVideoEncoderFactory : public webrtc::VideoEncoderFactory {
public:
    static std::unique_ptr<webrtc::VideoEncoderFactory> Create(const std::vector<std::string>& preferred_codecs);

    virtual ~VGVideoEncoderFactory() = default;

    std::vector<webrtc::SdpVideoFormat> GetSupportedFormats() const override;
    std::unique_ptr<webrtc::VideoEncoder> CreateVideoEncoder(const webrtc::SdpVideoFormat& format) override;

protected:
    VGVideoEncoderFactory(const std::vector<std::string>& preferred_codecs);

    std::unique_ptr<webrtc::VideoEncoderFactory> platform_factory_;

private:
    void CodecStringToFormat(const std::vector<std::string> preferred_codecs);
    std::vector<webrtc::SdpVideoFormat> SortListOfPreferredFormats() const;
    std::vector<webrtc::SdpVideoFormat> GetFormatsByCodecName(const webrtc::SdpVideoFormat& f) const;

    std::vector<webrtc::SdpVideoFormat> preferred_formats_;
};

class VGVideoDecoderFactory {
public:
    static std::unique_ptr<webrtc::VideoDecoderFactory> Create();
};

}
