/*
 *  Copyright (c) 2014 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#ifndef MODULES_VONAGE_MODULES_AUDIO_DEVICE_DUMMY_VONAGE_FILE_AUDIO_DEVICE_FACTORY_H_
#define MODULES_VONAGE_MODULES_AUDIO_DEVICE_DUMMY_VONAGE_FILE_AUDIO_DEVICE_FACTORY_H_

#include <stdint.h>
#include <stddef.h>

namespace vonage {

class FileAudioDevice;

// This class is used by audio_device_impl.cc when WebRTC is compiled with
// WEBRTC_DUMMY_FILE_DEVICES. The application must include this file and set the
// filenames to use before the audio device module is initialized. This is
// intended for test tools which use the audio device module.
class FileAudioDeviceFactory {
 public:
  static FileAudioDevice* CreateFileAudioDevice();

  // The input file must be a readable 48k stereo raw file. The output
  // file must be writable. The strings will be copied.
    static void SetInputFile(const char* inputAudioFilename);
    static void SetOutputFile(const char* outputAudioFilename, int32_t playingSampleRate, size_t playingNumChannels);
    static void Reset();
 private:
  enum : uint32_t { MAX_FILENAME_LEN = 512 };
  static char _inputAudioFilename[MAX_FILENAME_LEN];
  static char _outputAudioFilename[MAX_FILENAME_LEN];
    static int32_t _playingSampleRate;
    static size_t _playingNumChannels;
};

}  // namespace vonage

#endif  // MODULES_VONAGE_MODULES_AUDIO_DEVICE_DUMMY_VONAGE_FILE_AUDIO_DEVICE_FACTORY_H_
