/*
 *  Copyright (c) 2012 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#ifndef MODULES_VONAGE_MODULES_AUDIO_DEVICE_INCLUDE_VONAGE_AUDIO_DEVICE_H_
#define MODULES_VONAGE_MODULES_AUDIO_DEVICE_INCLUDE_VONAGE_AUDIO_DEVICE_H_

#include "api/scoped_refptr.h"
#include "api/task_queue/task_queue_factory.h"
#include "modules/audio_device/include/audio_device.h"

namespace vonage {

class AudioDeviceModule {
 public:
  // Creates a default ADM for usage in production code.
  static rtc::scoped_refptr<webrtc::AudioDeviceModule> Create(
      webrtc::AudioDeviceModule::AudioLayer audio_layer,
      webrtc::TaskQueueFactory* task_queue_factory);
  // Creates an ADM with support for extra test methods. Don't use this factory
  // in production code.
  static rtc::scoped_refptr<webrtc::AudioDeviceModuleForTest> CreateForTest(
      webrtc::AudioDeviceModule::AudioLayer audio_layer,
      webrtc::TaskQueueFactory* task_queue_factory);
};

}  // namespace vonage

#endif  // MODULES_VONAGE_MODULES_AUDIO_DEVICE_INCLUDE_VONAGE_AUDIO_DEVICE_H_
