#ifndef MODULES_VONAGE_MODULES_RTP_RTCP_SOURCE_RTP_HEADER_EXTENSIONS_H_
#define MODULES_VONAGE_MODULES_RTP_RTCP_SOURCE_RTP_HEADER_EXTENSIONS_H_

#include <stddef.h>
#include <stdint.h>

#include <algorithm>
#include <cstdint>
#include <vector>

#include "absl/strings/string_view.h"
#include "api/array_view.h"
#include "api/rtp_parameters.h"
#include "modules/rtp_rtcp/include/rtp_rtcp_defines.h"

namespace webrtc {

class InVideoFrameAugmentedDataExtensionI {
public:
    using value_type = uint8_t;
    static constexpr RTPExtensionType kId = kRtpExtensionInVideoFrameAugmentedDataI;
    static constexpr uint8_t kValueSizeBytes = 16;
    static constexpr absl::string_view Uri() {
        return RtpExtension::kInVideoFrameAugmentedDataIUri;
    }
    static bool Parse(rtc::ArrayView<const uint8_t> data,
                      std::vector<uint8_t>* in_video_frame_augmented_data);
    static size_t ValueSize(rtc::ArrayView<const uint8_t> in_video_frame_augmented_data) {
        return std::min(in_video_frame_augmented_data.size(), static_cast<size_t>(kValueSizeBytes));
    }
    static bool Write(rtc::ArrayView<uint8_t> data, rtc::ArrayView<const uint8_t> in_video_frame_augmented_data);
};

class InVideoFrameAugmentedDataExtensionII {
public:
    using value_type = uint8_t;
    static constexpr RTPExtensionType kId = kRtpExtensionInVideoFrameAugmentedDataII;
    static constexpr uint8_t kValueSizeBytes = 16;
    static constexpr absl::string_view Uri() {
        return RtpExtension::kInVideoFrameAugmentedDataIIUri;
    }
    static bool Parse(rtc::ArrayView<const uint8_t> data,
                      std::vector<uint8_t>* in_video_frame_augmented_data);
    static size_t ValueSize(rtc::ArrayView<const uint8_t> in_video_frame_augmented_data) {
        return std::min(in_video_frame_augmented_data.size(), static_cast<size_t>(kValueSizeBytes));
    }
    static bool Write(rtc::ArrayView<uint8_t> data, rtc::ArrayView<const uint8_t> in_video_frame_augmented_data);
};

}  // namespace webrtc

#endif  // MODULES_VONAGE_MODULES_RTP_RTCP_SOURCE_RTP_HEADER_EXTENSIONS_H_
