/*
 *  Copyright (c) 2015 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#pragma once

#include <mfapi.h>
#include <mferror.h>
#include <mfidl.h>
#include <mfreadwrite.h>
#include <wrl.h>
#include "../utils/sample_attribute_queue.h"
#include "api/video_codecs/video_decoder.h"
#include "modules/video_coding/codecs/h264/include/h264.h"
#include "rtc_base/synchronization/mutex.h"
#include "common_video/include/video_frame_buffer_pool.h"

namespace vonage {

class H264DecoderMFImpl : public webrtc::H264Decoder {
 public:
  H264DecoderMFImpl();

  virtual ~H264DecoderMFImpl();

  bool Configure(const webrtc::VideoDecoder::Settings& settings) override;
  
  int Decode(const webrtc::EncodedImage& input_image,
             bool missing_frames,
             int64_t /*render_time_ms*/) override;

  int RegisterDecodeCompleteCallback(
      webrtc::DecodedImageCallback* callback) override;

  int Release() override;

  const char* ImplementationName() const override;

 private:
  HRESULT FlushFrames(uint32_t timestamp, uint64_t ntp_time_ms);
  HRESULT EnqueueFrame(const webrtc::EncodedImage& input_image,
                       bool missing_frames);

 private:
  Microsoft::WRL::ComPtr<IMFTransform> decoder_;
  webrtc::VideoFrameBufferPool buffer_pool_;

  bool inited_ = false;
  bool require_keyframe_ = true;
  uint32_t first_frame_rtp_ = 0;
  int width_;
  int height_;
  webrtc::Mutex crit_;
  webrtc::DecodedImageCallback* decode_complete_callback_;
};

}