/*
 *  Copyright (c) 2015 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */
#pragma once

#include <memory>
#include <string>

#include "api/video_codecs/video_decoder_factory.h"
#include "api/video_codecs/video_encoder_factory.h"

namespace vonage {

class H264MFEncoderFactory : public webrtc::VideoEncoderFactory {
 public:
  H264MFEncoderFactory();
  ~H264MFEncoderFactory() override = default;

  std::vector<webrtc::SdpVideoFormat> GetSupportedFormats() const override;

  std::unique_ptr<webrtc::VideoEncoder> CreateVideoEncoder(
      const webrtc::SdpVideoFormat& format) override;

 private:
  const std::unique_ptr<VideoEncoderFactory> builtin_video_encoder_factory_;
};

class H264MFDecoderFactory : public webrtc::VideoDecoderFactory {
 public:
  H264MFDecoderFactory();
  ~H264MFDecoderFactory() override = default;

  std::vector<webrtc::SdpVideoFormat> GetSupportedFormats() const override;

  std::unique_ptr<webrtc::VideoDecoder> CreateVideoDecoder(
      const webrtc::SdpVideoFormat& format) override;

 private:
  const std::unique_ptr<VideoDecoderFactory> builtin_video_decoder_factory_;
};

}  // namespace vonage
