/*
 *  Copyright (c) 2015 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#pragma once

#include <stdio.h>
#include <tchar.h>
#include <windows.h>

#ifdef _DEBUG
#define VONAGE_ON_SUCCEEDED(act)                                                  \
  if (SUCCEEDED(hr)) {                                                     \
    hr = (act);                                                            \
    if (FAILED(hr)) {                                                      \
      if (FACILITY_WINDOWS == HRESULT_FACILITY(hr))                        \
        hr = HRESULT_CODE(hr);                                             \
      TCHAR* szErrMsg;                                                     \
                                                                           \
      if (FormatMessage(                                                   \
              FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM, \
              NULL, hr, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),         \
              (LPTSTR)&szErrMsg, 0, NULL) != 0) {                          \
        std::wstring wStr = szErrMsg;                                      \
        std::string str = std::string(wStr.begin(), wStr.end());           \
        RTC_LOG(LS_WARNING) << "Error description is: " << str;            \
        LocalFree(szErrMsg);                                               \
      } else                                                               \
        RTC_LOG(LS_WARNING)                                                \
            << "Could not find a description for error " << hr;            \
      RTC_LOG(LS_WARNING) << "ERROR:" << #act;                             \
      __debugbreak();                                                      \
    }                                                                      \
  }
#else
#define VONAGE_ON_SUCCEEDED(act)                      \
  if (SUCCEEDED(hr)) {                         \
    hr = (act);                                \
    if (FAILED(hr)) {                          \
      RTC_LOG(LS_WARNING) << "ERROR:" << #act; \
    }                                          \
  }
#endif
