#ifndef MODULES_VONAGE_PC_VONAGE_PEER_CONNECTION_FACTORY_H_
#define MODULES_VONAGE_PC_VONAGE_PEER_CONNECTION_FACTORY_H_

#include "modules/vonage/api/version.h"
#include "modules/vonage/pc/vonage_peer_connection_factory_interface.h"

namespace vonage {

class ThreadWrapper;

#if VONAGE_WEBRTC_VERSION == 99
using PeerConnectionTrialsWrapper = webrtc::WebRtcKeyValueConfig;
#elif VONAGE_WEBRTC_VERSION == 121
using PeerConnectionTrialsWrapper = webrtc::FieldTrialsView;
#endif

struct VGPeerConnectionFactoryDependencies final {
    VGPeerConnectionFactoryDependencies();
    // This object is not copyable or assignable.
    VGPeerConnectionFactoryDependencies(const VGPeerConnectionFactoryDependencies&) = delete;
    VGPeerConnectionFactoryDependencies& operator=(const VGPeerConnectionFactoryDependencies&) = delete;
    // This object is only moveable.
    VGPeerConnectionFactoryDependencies(VGPeerConnectionFactoryDependencies&&);
    VGPeerConnectionFactoryDependencies& operator=(VGPeerConnectionFactoryDependencies&&) = default;
    ~VGPeerConnectionFactoryDependencies();


    // Optional dependencies. This can grow.
    // TODO: OW-398: Alow to use custom/external audio device modules under Vonage peer connection factory helper class (WONTDO?).
    // TODO: OW-401: Review WebRTC peer connection factory field trials and think about exposing a setter for them under Vonage peer connection factory helper class (DONE?).
    std::unique_ptr<PeerConnectionTrialsWrapper> field_trials;
    // TODO: OW-402: Allow to use custom/external video sources under Vonage peer connection factory helper class (WONTDO/INVALID?).
};

class VGPeerConnectionFactory : public VGPeerConnectionFactoryInterface {
public:
    static std::unique_ptr<VGPeerConnectionFactory> Create(const VGPeerConnectionFactoryInterface::Options& options, VGPeerConnectionFactoryDependencies dependencies);

    virtual ~VGPeerConnectionFactory();

    rtc::scoped_refptr<webrtc::PeerConnectionInterface> CreatePeerConnection(const webrtc::PeerConnectionInterface::RTCConfiguration& configuration, webrtc::PeerConnectionDependencies dependencies) override;

    rtc::scoped_refptr<webrtc::AudioSourceInterface> CreateAudioSource() override;

    rtc::scoped_refptr<webrtc::AudioTrackInterface> CreateAudioTrack(const std::string& label, const rtc::scoped_refptr<webrtc::AudioSourceInterface>& audio_source) override;

    rtc::scoped_refptr<webrtc::VideoTrackInterface> CreateVideoTrack(const std::string& label, const rtc::scoped_refptr<webrtc::VideoTrackSourceInterface>& video_source) override;

    ThreadWrapper* GetSignalingThread() override;

    ThreadWrapper* GetWorkerThread() override;

    ThreadWrapper* GetNetworkThread() override;

protected:
    VGPeerConnectionFactory(const VGPeerConnectionFactoryInterface::Options& options, VGPeerConnectionFactoryDependencies dependencies);

    void CreateDefaultTaskQueueFactory();
    virtual rtc::scoped_refptr<webrtc::AudioDeviceModule> CreateAudioDeviceModule();
    virtual rtc::scoped_refptr<webrtc::AudioProcessing> CreateAudioProcessing();
    bool Init();

    std::unique_ptr<ThreadWrapper> network_thread_;
    std::unique_ptr<ThreadWrapper> worker_thread_;
    std::unique_ptr<ThreadWrapper> signaling_thread_;
    std::unique_ptr<webrtc::TaskQueueFactory> task_queue_factory_;

private:
    bool initialized_ = false;
    Options options_;
    std::unique_ptr<PeerConnectionTrialsWrapper> field_trials_;
    rtc::scoped_refptr<webrtc::PeerConnectionFactoryInterface> peer_connection_factory_;
    std::vector<std::unique_ptr<webrtc::PeerConnectionObserver>> peer_connection_observers_;
};

}

#endif // MODULES_VONAGE_PC_VONAGE_PEER_CONNECTION_FACTORY_H_
