#ifndef MODULES_VONAGE_PC_VONAGE_PEER_CONNECTION_FACTOTY_INTERFACE_H_
#define MODULES_VONAGE_PC_VONAGE_PEER_CONNECTION_FACTOTY_INTERFACE_H_

#include <memory>
#include <unordered_map>
#include <vector>

#include "api/peer_connection_interface.h"

namespace vonage {

class ThreadWrapper;

class VGPeerConnectionFactoryInterface {
public:
    using AudioOptionsMap = std::unordered_map<std::string, bool>;

    struct Options {
        Options() = default;
        ~Options() = default;

        static constexpr char kAudioEchoCancellation[] = "echo_cancellation";
        static constexpr char kAudioAutoGainControl[] = "auto_gain_control";
        static constexpr char kAudioNoiseSuppression[] = "noise_suppression";
        static constexpr char kAudioHighpassFilter[] = "highpass_filter";

        bool disable_encryption = false;
        // SRTP GCM crypto suites.
        bool enable_srtp_gcm_crypto_suites = false;
        std::vector<int> srtp_custom_sorted_gcm_crypto_suites;
        bool sframe_require_frame_encryption = false;
        // Video codecs and preferred order.
        std::vector<std::string> video_codec_names;
        // Audio codecs and preferred order.
        std::vector<std::string> audio_codec_names;
        AudioOptionsMap audio_options;
    };

    virtual ~VGPeerConnectionFactoryInterface() = default;

    virtual rtc::scoped_refptr<webrtc::PeerConnectionInterface> CreatePeerConnection(const webrtc::PeerConnectionInterface::RTCConfiguration& configuration, webrtc::PeerConnectionDependencies dependencies) = 0;
    virtual rtc::scoped_refptr<webrtc::AudioSourceInterface> CreateAudioSource() = 0;
    virtual rtc::scoped_refptr<webrtc::AudioTrackInterface> CreateAudioTrack(const std::string& label, const rtc::scoped_refptr<webrtc::AudioSourceInterface>& audio_source) = 0;
    virtual rtc::scoped_refptr<webrtc::VideoTrackInterface> CreateVideoTrack(const std::string& label, const rtc::scoped_refptr<webrtc::VideoTrackSourceInterface>& video_source) = 0;
    virtual ThreadWrapper* GetSignalingThread() = 0;
    virtual ThreadWrapper* GetWorkerThread() = 0;
    virtual ThreadWrapper* GetNetworkThread() = 0;
};

}

#endif // MODULES_VONAGE_API_VONAGE_PEER_CONNECTION_FACTOTY_INTERFACE_H_
