/*
 * Decompiled with CFR 0.152.
 */
package com.vorlonsoft.android.rate;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

final class AppInformation {
    private static volatile AppInformation singleton = null;
    private final long appLongVersionCode;
    private final String appPackageName;
    private final String appVersionName;
    private final Drawable appIcon;

    /*
     * WARNING - void declaration
     */
    private AppInformation(long appLongVersionCode, @NonNull String appPackageName, @NonNull String appVersionName, @Nullable Drawable appIcon) {
        void var3_2;
        void var1_1;
        this.appLongVersionCode = var1_1;
        this.appPackageName = var3_2;
        this.appVersionName = appVersionName;
        this.appIcon = appIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    static AppInformation getInstance(@NonNull Context context) {
        Object appVersionName;
        long appLongVersionCode;
        Object packageInfo;
        Drawable appIcon;
        if (singleton != null) return singleton;
        String appPackageName = context.getPackageName();
        Object pm = context.getPackageManager();
        try {
            appIcon = pm.getApplicationIcon(appPackageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.i((String)"ANDROIDRATE", (String)"Failed to get app icon", (Throwable)e);
            appIcon = null;
        }
        try {
            packageInfo = pm.getPackageInfo(appPackageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.i((String)"ANDROIDRATE", (String)"Failed to get app package info", (Throwable)e);
            packageInfo = null;
        }
        if (packageInfo != null) {
            appLongVersionCode = Build.VERSION.SDK_INT < 28 ? (long)packageInfo.versionCode & 0xFFFFFFFFL : packageInfo.getLongVersionCode();
            appVersionName = packageInfo.versionName;
        } else {
            appLongVersionCode = 0L;
            appVersionName = "";
        }
        Class<AppInformation> clazz = AppInformation.class;
        synchronized (AppInformation.class) {
            Object object;
            void var3_2;
            void var1_7;
            if (singleton != null) return singleton;
            singleton = new AppInformation((long)var1_7, (String)var3_2, (String)object, appIcon);
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return singleton;
        }
    }

    final int getAppVersionCode() {
        return (int)(this.appLongVersionCode & 0xFFFFFFFFL);
    }

    final int getAppVersionCodeMajor() {
        return (int)(this.appLongVersionCode >>> 32);
    }

    final long getAppLongVersionCode() {
        return this.appLongVersionCode;
    }

    final String getAppPackageName() {
        return this.appPackageName;
    }

    final String getAppVersionName() {
        return this.appVersionName;
    }

    @Nullable
    final Drawable getAppIcon() {
        return this.appIcon;
    }
}

