/*
 * Decompiled with CFR 0.152.
 */
package com.vorlonsoft.android.rate;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.ArrayMap;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import androidx.annotation.Nullable;
import com.vorlonsoft.android.rate.AppInformation;
import com.vorlonsoft.android.rate.DefaultDialogManager;
import com.vorlonsoft.android.rate.DialogManager;
import com.vorlonsoft.android.rate.DialogOptions;
import com.vorlonsoft.android.rate.OnClickButtonListener;
import com.vorlonsoft.android.rate.PreferenceHelper;
import com.vorlonsoft.android.rate.StoreOptions;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class AppRate {
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile AppRate singleton = null;
    private final Map<String, Short> customEventsCounts;
    private final Context context;
    private final DialogOptions dialogOptions = new DialogOptions();
    private final StoreOptions storeOptions = new StoreOptions();
    private boolean isDebug = false;
    private boolean isVersionCodeCheck = false;
    private boolean isVersionNameCheck = false;
    private long installDate = 864000000L;
    private byte appLaunchTimes = (byte)10;
    private long remindInterval = 86400000L;
    private byte remindLaunchesNumber = 0;
    private byte selectedAppLaunches = 1;
    private short dialogLaunchTimes = Short.MAX_VALUE;
    private WeakReference<Dialog> dialog = null;
    private DialogManager.Factory dialogManagerFactory = new DefaultDialogManager.Factory();

    /*
     * WARNING - void declaration
     */
    private AppRate(Context context) {
        void var1_1;
        this.customEventsCounts = Build.VERSION.SDK_INT >= 19 ? new ArrayMap() : new HashMap<String, Short>();
        this.context = var1_1.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppRate with(Context context) {
        if (singleton != null) return singleton;
        Class<AppRate> clazz = AppRate.class;
        synchronized (AppRate.class) {
            Context context2;
            if (singleton != null) return singleton;
            singleton = new AppRate(context2);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean showRateDialogIfMeetsConditions(Activity activity) {
        void var1_1;
        boolean isMeetsConditions = singleton != null && (singleton.isDebug() || singleton.shouldShowRateDialog());
        if (isMeetsConditions) {
            Activity activity2;
            singleton.showRateDialog(activity2);
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isOverDate(long targetDate, long threshold) {
        void var3_2;
        void var1_1;
        return new Date().getTime() - var1_1 >= var3_2;
    }

    private boolean isBelow365DayPeriodMaxNumberDialogLaunchTimes() {
        return this.dialogLaunchTimes == Short.MAX_VALUE || PreferenceHelper.get365DayPeriodDialogLaunchTimes(this.context) < this.dialogLaunchTimes;
    }

    final void clearRateDialog() {
        if (this.dialog != null) {
            this.dialog.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate set365DayPeriodMaxNumberDialogLaunchTimes(short dialogLaunchTimes) {
        void var1_1;
        this.dialogLaunchTimes = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setLaunchTimes(byte appLaunchTimes) {
        void var1_1;
        this.appLaunchTimes = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setInstallDays(byte installDate) {
        void var1_1;
        return this.setTimeToWait(86400000L, (short)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setTimeToWait(long timeUnit, short timeUnitsNumber) {
        void var3_2;
        void var1_1;
        this.installDate = var1_1 * (long)var3_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setRemindInterval(byte remindInterval) {
        void var1_1;
        return this.setRemindTimeToWait(86400000L, (short)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setRemindTimeToWait(long timeUnit, short timeUnitsNumber) {
        void var3_2;
        void var1_1;
        this.remindInterval = var1_1 * (long)var3_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setRemindLaunchesNumber(byte remindLaunchesNumber) {
        void var1_1;
        this.remindLaunchesNumber = var1_1;
        return this;
    }

    public final AppRate clearRemindButtonClick() {
        PreferenceHelper.clearRemindButtonClick(this.context);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setMinimumEventCount(String eventName, short minimumCount) {
        void var2_2;
        void var1_1;
        this.customEventsCounts.put((String)var1_1, (short)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setSelectedAppLaunches(byte selectedAppLaunches) {
        void var1_1;
        this.selectedAppLaunches = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setRemindLaunchTimes(byte selectedAppLaunches) {
        void var1_1;
        return this.setSelectedAppLaunches((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setShowLaterButton(boolean isShowNeutralButton) {
        void var1_1;
        this.dialogOptions.setShowNeutralButton((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setShowNeverButton(boolean isShowNeverButton) {
        void var1_1;
        this.dialogOptions.setShowNegativeButton((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setShowTitle(boolean isShowTitle) {
        void var1_1;
        this.dialogOptions.setShowTitle((boolean)var1_1);
        return this;
    }

    public final AppRate clearAgreeShowDialog() {
        PreferenceHelper.setIsAgreeShowDialog(this.context, true);
        return this;
    }

    public final AppRate clearSettingsParam() {
        PreferenceHelper.clearSharedPreferences(this.context);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setAgreeShowDialog(boolean isAgree) {
        void var1_1;
        PreferenceHelper.setIsAgreeShowDialog(this.context, (boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setView(View view) {
        void var1_1;
        this.dialogOptions.setView((View)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setOnClickButtonListener(OnClickButtonListener listener) {
        void var1_1;
        this.dialogOptions.setListener((OnClickButtonListener)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setTitle(int resourceId) {
        void var1_1;
        this.dialogOptions.setTitleResId((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setTitle(String title) {
        void var1_1;
        this.dialogOptions.setTitleText((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setMessage(int resourceId) {
        void var1_1;
        this.dialogOptions.setMessageResId((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setMessage(String message) {
        void var1_1;
        this.dialogOptions.setMessageText((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setTextRateNow(int resourceId) {
        void var1_1;
        this.dialogOptions.setTextPositiveResId((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setTextRateNow(String positiveText) {
        void var1_1;
        this.dialogOptions.setPositiveText((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setTextLater(int resourceId) {
        void var1_1;
        this.dialogOptions.setTextNeutralResId((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setTextLater(String neutralText) {
        void var1_1;
        this.dialogOptions.setNeutralText((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setTextNever(int resourceId) {
        void var1_1;
        this.dialogOptions.setTextNegativeResId((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setTextNever(String negativeText) {
        void var1_1;
        this.dialogOptions.setNegativeText((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setCancelable(boolean cancelable) {
        void var1_1;
        this.dialogOptions.setCancelable((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setStoreType(int storeType) throws IllegalArgumentException {
        void var1_1;
        if (storeType == 1 || storeType == 3) {
            throw new IllegalArgumentException("For StoreType.APPLE/StoreType.BLACKBERRY you must use setStoreType(StoreType.APPLE/StoreType.BLACKBERRY, long applicationId)");
        }
        if (storeType < 0 || storeType > 10) {
            throw new IllegalArgumentException("StoreType must be one of: AMAZON, APPLE, BAZAAR, BLACKBERRY, CHINESESTORES, GOOGLEPLAY, MI, SAMSUNG, SLIDEME, TENCENT, YANDEX");
        }
        return this.setStoreType((int)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setStoreType(int storeType, long applicationId) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        if (storeType < 0 || storeType > 10) {
            throw new IllegalArgumentException("StoreType must be one of: AMAZON, APPLE, BAZAAR, BLACKBERRY, CHINESESTORES, GOOGLEPLAY, MI, SAMSUNG, SLIDEME, TENCENT, YANDEX");
        }
        if (storeType != 1 && storeType != 3) {
            return this.setStoreType(storeType, null, null);
        }
        return this.setStoreType((int)var1_1, new String[]{String.valueOf((long)var2_2)}, null);
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setStoreType(String ... uris) throws IllegalArgumentException {
        void var1_1;
        if (uris == null) {
            throw new IllegalArgumentException("setStoreType(String... uris): 'uris' must be != null");
        }
        return this.setStoreType(12, (String[])var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private AppRate setStoreType(int storeType, String[] stringParam, Intent[] intentParaam) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.storeOptions.setStoreType((int)var1_1, (String[])var2_2, (Intent[])var3_3);
        return this;
    }

    public final int getStoreType() {
        return this.storeOptions.getStoreType();
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setStoreType(Intent ... intents) throws IllegalArgumentException {
        void var1_1;
        if (intents == null) {
            throw new IllegalArgumentException("setStoreType(Intent... intents): 'intents' must be != null");
        }
        return this.setStoreType(11, null, (Intent[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate incrementEventCount(String eventName) {
        void var1_1;
        return this.setEventCountValue(eventName, (short)(PreferenceHelper.getCustomEventCount(this.context, (String)var1_1) + 1));
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setEventCountValue(String eventName, short countValue) {
        void var2_2;
        void var1_1;
        PreferenceHelper.setCustomEventCount(this.context, (String)var1_1, (short)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setThemeResId(int themeResId) {
        void var1_1;
        this.dialogOptions.setThemeResId((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setDialogManagerFactory(@Nullable DialogManager.Factory dialogManagerFactory) {
        this.dialogManagerFactory.clearDialogManager();
        if (dialogManagerFactory == null) {
            this.dialogManagerFactory = new DefaultDialogManager.Factory();
        } else {
            void var1_1;
            dialogManagerFactory.clearDialogManager();
            this.dialogManagerFactory = var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setVersionCodeCheck(boolean isVersionCodeCheck) {
        void var1_1;
        this.isVersionCodeCheck = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setVersionNameCheck(boolean isVersionNameCheck) {
        void var1_1;
        this.isVersionNameCheck = var1_1;
        return this;
    }

    public final void monitor() {
        if (PreferenceHelper.isFirstLaunch(this.context)) {
            PreferenceHelper.setFirstLaunchSharedPreferences(this.context);
            return;
        }
        PreferenceHelper.setLaunchTimes(this.context, (short)(PreferenceHelper.getLaunchTimes(this.context) + 1));
        if (AppInformation.getInstance(this.context).getAppLongVersionCode() != PreferenceHelper.getVersionCode(this.context)) {
            if (this.isVersionCodeCheck) {
                PreferenceHelper.setIsAgreeShowDialog(this.context, true);
            }
            PreferenceHelper.setVersionCode(this.context);
        }
        if (!AppInformation.getInstance(this.context).getAppVersionName().equals(PreferenceHelper.getVersionName(this.context))) {
            if (this.isVersionNameCheck) {
                PreferenceHelper.setIsAgreeShowDialog(this.context, true);
            }
            PreferenceHelper.setVersionName(this.context);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void showRateDialog(Activity activity) {
        this.dismissRateDialog();
        this.dialog = new WeakReference<Dialog>(this.dialogManagerFactory.createDialogManager((Context)activity, this.dialogOptions, this.storeOptions).createDialog());
        if (this.dialog.get() != null) {
            try {
                if (!activity.isFinishing()) {
                    ((Dialog)this.dialog.get()).show();
                    return;
                }
                Log.w((String)"ANDROIDRATE", (String)"Failed to rate app, can't show rate dialog, because activity is in the process of finishing");
                return;
            }
            catch (Exception e) {
                void var1_2;
                Log.w((String)"ANDROIDRATE", (String)"Failed to rate app, can't show rate dialog, because unpredictable exception", (Throwable)var1_2);
                return;
            }
        }
        Log.w((String)"ANDROIDRATE", (String)"Failed to rate app, can't create rate dialog");
    }

    public final boolean isShowingRateDialog() {
        return this.dialog != null && this.dialog.get() != null && ((Dialog)this.dialog.get()).isShowing();
    }

    public final void dismissRateDialog() {
        if (this.dialog != null && this.dialog.get() != null) {
            ((Dialog)this.dialog.get()).dismiss();
        }
        this.clearRateDialog();
    }

    /*
     * WARNING - void declaration
     */
    public final void rateNow(Activity activity) {
        Button positiveButton;
        if (this.dialog != null && this.dialog.get() != null) {
            positiveButton = ((AlertDialog)this.dialog.get()).getButton(-1);
            if (positiveButton != null) {
                positiveButton.performClick();
                this.dismissRateDialog();
                return;
            }
            Log.w((String)"ANDROIDRATE", (String)"Failed to rate app, can't get dialog positive button");
            return;
        }
        this.clearRateDialog();
        this.dialog = new WeakReference<Dialog>(this.dialogManagerFactory.createDialogManager((Context)positiveButton, this.dialogOptions, this.storeOptions).createDialog());
        if (this.dialog.get() != null) {
            positiveButton = ((AlertDialog)this.dialog.get()).getButton(-1);
            if (positiveButton != null) {
                void var1_1;
                var1_1.performClick();
            } else {
                Log.w((String)"ANDROIDRATE", (String)"Failed to rate app, can't get dialog positive button");
            }
        } else {
            Log.w((String)"ANDROIDRATE", (String)"Failed to rate app, can't create rate dialog");
        }
        this.clearRateDialog();
    }

    public final boolean shouldShowRateDialog() {
        return PreferenceHelper.getIsAgreeShowDialog(this.context) && this.isOverLaunchTimes() && this.isSelectedAppLaunch() && this.isOverInstallDate() && this.isOverRemindDate() && this.isOverRemindLaunchesNumber() && this.isOverCustomEventsRequirements() && this.isBelow365DayPeriodMaxNumberDialogLaunchTimes();
    }

    private boolean isOverLaunchTimes() {
        return this.appLaunchTimes == 0 || PreferenceHelper.getLaunchTimes(this.context) >= this.appLaunchTimes;
    }

    private boolean isSelectedAppLaunch() {
        return this.selectedAppLaunches == 1 || this.selectedAppLaunches != 0 && PreferenceHelper.getLaunchTimes(this.context) % this.selectedAppLaunches == 0;
    }

    private boolean isOverInstallDate() {
        block3: {
            block2: {
                if (this.installDate == 0L) break block2;
                AppRate appRate = this;
                if (!appRate.isOverDate(PreferenceHelper.getInstallDate(appRate.context), this.installDate)) break block3;
            }
            return true;
        }
        return false;
    }

    private boolean isOverRemindDate() {
        block3: {
            block2: {
                if (this.remindInterval == 0L || PreferenceHelper.getRemindInterval(this.context) == 0L) break block2;
                AppRate appRate = this;
                if (!appRate.isOverDate(PreferenceHelper.getRemindInterval(appRate.context), this.remindInterval)) break block3;
            }
            return true;
        }
        return false;
    }

    private boolean isOverRemindLaunchesNumber() {
        return this.remindLaunchesNumber == 0 || PreferenceHelper.getRemindLaunchesNumber(this.context) == 0 || PreferenceHelper.getLaunchTimes(this.context) - PreferenceHelper.getRemindLaunchesNumber(this.context) >= this.remindLaunchesNumber;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isOverCustomEventsRequirements() {
        if (this.customEventsCounts.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, Short> eventRequirement : this.customEventsCounts.entrySet()) {
            void var2_2;
            if (PreferenceHelper.getCustomEventCount(this.context, eventRequirement.getKey()) >= (Short)var2_2.getValue()) continue;
            return false;
        }
        return true;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    /*
     * WARNING - void declaration
     */
    public final AppRate setDebug(boolean isDebug) {
        void var1_1;
        this.isDebug = var1_1;
        return this;
    }
}

