/*
 * Decompiled with CFR 0.152.
 */
package com.vorlonsoft.android.rate;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vorlonsoft.android.rate.AppInformation;
import com.vorlonsoft.android.rate.AppRate;
import com.vorlonsoft.android.rate.DialogManager;
import com.vorlonsoft.android.rate.DialogOptions;
import com.vorlonsoft.android.rate.IntentHelper;
import com.vorlonsoft.android.rate.OnClickButtonListener;
import com.vorlonsoft.android.rate.PreferenceHelper;
import com.vorlonsoft.android.rate.StoreOptions;
import com.vorlonsoft.android.rate.Utils;
import java.lang.ref.WeakReference;

public class DefaultDialogManager
implements DialogManager {
    private static volatile WeakReference<DefaultDialogManager> singleton = null;
    private final StoreOptions storeOptions;
    private final OnClickButtonListener listener;
    protected final DialogOptions dialogOptions;
    protected Context context = null;
    protected final DialogInterface.OnShowListener showListener = dialog -> {
        if (PreferenceHelper.getDialogFirstLaunchTime(this.context) == 0L) {
            PreferenceHelper.setDialogFirstLaunchTime(this.context);
        }
        PreferenceHelper.increment365DayPeriodDialogLaunchTimes(this.context);
        if (Utils.isLollipop()) {
            try {
                LinearLayout linearLayout;
                Button positiveButton = ((AlertDialog)dialog).getButton(-1);
                if (positiveButton != null && (linearLayout = (LinearLayout)positiveButton.getParent()) != null && positiveButton.getLeft() + positiveButton.getWidth() > linearLayout.getWidth()) {
                    Button neutralButton = ((AlertDialog)dialog).getButton(-3);
                    Button negativeButton = ((AlertDialog)dialog).getButton(-2);
                    linearLayout.setOrientation(1);
                    linearLayout.setGravity(0x800005);
                    if (neutralButton != null) {
                        void var2_2;
                        linearLayout.removeView((View)neutralButton);
                        if (negativeButton != null) {
                            linearLayout.removeView((View)negativeButton);
                            linearLayout.addView((View)negativeButton);
                        }
                        linearLayout.addView((View)var2_2);
                        return;
                    }
                    if (negativeButton != null) {
                        void var1_1;
                        void var3_3;
                        linearLayout.removeView((View)negativeButton);
                        var3_3.addView((View)var1_1);
                    }
                }
                return;
            }
            catch (Exception exception) {
                Log.i((String)"ANDROIDRATE", (String)"Positive button may not fits in the window, can't change layout orientation to vertical");
            }
        }
    };
    protected final DialogInterface.OnDismissListener dismissListener = dialog -> AppRate.with(this.context).clearRateDialog();
    protected final DialogInterface.OnClickListener positiveListener = new DialogInterface.OnClickListener(this){
        final /* synthetic */ DefaultDialogManager this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void onClick(DialogInterface dialog, int which) {
            block26: {
                Intent[] intentsToAppStores;
                String packageName = AppInformation.getInstance(this.this$0.context).getAppPackageName();
                if (packageName != null && packageName.hashCode() != "".hashCode()) {
                    switch (this.this$0.storeOptions.getStoreType()) {
                        case 0: {
                            intentsToAppStores = IntentHelper.createIntentsForStore(this.this$0.context, 0, packageName);
                            break;
                        }
                        case 1: {
                            intentsToAppStores = IntentHelper.createIntentsForStore(this.this$0.context, 1, this.this$0.storeOptions.getApplicationId());
                            break;
                        }
                        case 2: {
                            intentsToAppStores = IntentHelper.createIntentsForStore(this.this$0.context, 2, (String)intentsToAppStores);
                            break;
                        }
                        case 3: {
                            intentsToAppStores = IntentHelper.createIntentsForStore(this.this$0.context, 3, this.this$0.storeOptions.getApplicationId());
                            break;
                        }
                        case 4: {
                            intentsToAppStores = IntentHelper.createIntentsForStore(this.this$0.context, 4, (String)intentsToAppStores);
                            break;
                        }
                        case 6: {
                            intentsToAppStores = IntentHelper.createIntentsForStore(this.this$0.context, 6, (String)intentsToAppStores);
                            break;
                        }
                        case 7: {
                            intentsToAppStores = IntentHelper.createIntentsForStore(this.this$0.context, 7, (String)intentsToAppStores);
                            break;
                        }
                        case 8: {
                            intentsToAppStores = IntentHelper.createIntentsForStore(this.this$0.context, 8, (String)intentsToAppStores);
                            break;
                        }
                        case 9: {
                            intentsToAppStores = IntentHelper.createIntentsForStore(this.this$0.context, 9, (String)intentsToAppStores);
                            break;
                        }
                        case 10: {
                            intentsToAppStores = IntentHelper.createIntentsForStore(this.this$0.context, 10, (String)intentsToAppStores);
                            break;
                        }
                        case 11: 
                        case 12: {
                            intentsToAppStores = this.this$0.storeOptions.getIntents();
                            break;
                        }
                        default: {
                            intentsToAppStores = IntentHelper.createIntentsForStore(this.this$0.context, 5, (String)intentsToAppStores);
                        }
                    }
                    if (intentsToAppStores == null) {
                        Log.w((String)"ANDROIDRATE", (String)"Failed to rate app, can't create intents for store");
                    }
                } else {
                    Log.w((String)"ANDROIDRATE", (String)"Failed to rate app, can't get app package name");
                    intentsToAppStores = null;
                }
                try {
                    if (intentsToAppStores == null) break block26;
                    if (intentsToAppStores.length == 0) {
                        Log.w((String)"ANDROIDRATE", (String)"Failed to rate app, no intent found for startActivity (intentsToAppStores.length == 0)");
                    } else {
                        if (intentsToAppStores[0] == null) {
                            throw new ActivityNotFoundException("Failed to rate app, no intent found for startActivity (intentsToAppStores[0] == null)");
                        }
                        this.this$0.context.startActivity(intentsToAppStores[0]);
                    }
                }
                catch (ActivityNotFoundException e) {
                    Log.w((String)"ANDROIDRATE", (String)("Failed to rate app, no activity found for " + intentsToAppStores[0]), (Throwable)e);
                    byte intentsToAppStoresNumber = (byte)intentsToAppStores.length;
                    if (intentsToAppStoresNumber <= 1) break block26;
                    for (byte b = 1; b < intentsToAppStoresNumber; b = (byte)(b + 1)) {
                        boolean isCatch;
                        try {
                            if (intentsToAppStores[b] == null) {
                                throw new ActivityNotFoundException("Failed to rate app, no intent found for startActivity (intentsToAppStores[" + b + "] == null)");
                            }
                            this.this$0.context.startActivity(intentsToAppStores[b]);
                            isCatch = false;
                        }
                        catch (ActivityNotFoundException ex) {
                            Log.w((String)"ANDROIDRATE", (String)("Failed to rate app, no activity found for " + intentsToAppStores[b]), (Throwable)ex);
                            isCatch = true;
                        }
                        if (!isCatch) break;
                    }
                }
            }
            PreferenceHelper.setIsAgreeShowDialog(this.this$0.context, false);
            if (this.this$0.listener != null) {
                void var2_2;
                this.this$0.listener.onClickButton((byte)var2_2);
            }
        }
    };
    protected final DialogInterface.OnClickListener negativeListener = new DialogInterface.OnClickListener(this){
        final /* synthetic */ DefaultDialogManager this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void onClick(DialogInterface dialog, int which) {
            PreferenceHelper.setIsAgreeShowDialog(this.this$0.context, false);
            if (this.this$0.listener != null) {
                void var2_2;
                this.this$0.listener.onClickButton((byte)var2_2);
            }
        }
    };
    protected final DialogInterface.OnClickListener neutralListener = new DialogInterface.OnClickListener(this){
        final /* synthetic */ DefaultDialogManager this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void onClick(DialogInterface dialog, int which) {
            PreferenceHelper.setRemindInterval(this.this$0.context);
            PreferenceHelper.setRemindLaunchesNumber(this.this$0.context);
            if (this.this$0.listener != null) {
                void var2_2;
                this.this$0.listener.onClickButton((byte)var2_2);
            }
        }
    };

    /*
     * WARNING - void declaration
     */
    protected DefaultDialogManager(Context context, DialogOptions dialogOptions, StoreOptions storeOptions) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.context = var1_1;
        this.dialogOptions = dialogOptions;
        this.storeOptions = var3_3;
        this.listener = var2_2.getListener();
    }

    /*
     * WARNING - void declaration
     */
    protected void setContext(Context context) {
        void var1_1;
        this.context = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected AlertDialog.Builder getDialogBuilder(@NonNull Context context, int themeResId) {
        void var2_2;
        return Utils.getDialogBuilder(context, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Dialog createDialog() {
        void var1_1;
        AlertDialog alertDialog;
        DefaultDialogManager defaultDialogManager = this;
        AlertDialog.Builder builder = defaultDialogManager.getDialogBuilder(defaultDialogManager.context, this.dialogOptions.getThemeResId());
        if (builder == null) {
            return null;
        }
        builder.setMessage((CharSequence)this.dialogOptions.getMessageText(this.context));
        if (this.dialogOptions.shouldShowTitle()) {
            builder.setTitle((CharSequence)this.dialogOptions.getTitleText(this.context));
        }
        builder.setCancelable(this.dialogOptions.getCancelable());
        View view = this.dialogOptions.getView();
        if (view != null) {
            void var2_2;
            builder.setView((View)var2_2);
        }
        builder.setPositiveButton((CharSequence)this.dialogOptions.getPositiveText(this.context), this.positiveListener);
        if (this.dialogOptions.shouldShowNeutralButton()) {
            builder.setNeutralButton((CharSequence)this.dialogOptions.getNeutralText(this.context), this.neutralListener);
        }
        if (this.dialogOptions.shouldShowNegativeButton()) {
            builder.setNegativeButton((CharSequence)this.dialogOptions.getNegativeText(this.context), this.negativeListener);
        }
        if ((alertDialog = builder.create()) != null) {
            alertDialog.setOnShowListener(this.showListener);
            alertDialog.setOnDismissListener(this.dismissListener);
        }
        return var1_1;
    }

    static class Factory
    implements DialogManager.Factory {
        Factory() {
            if (singleton != null) {
                singleton.clear();
            }
        }

        @Override
        public void clearDialogManager() {
            if (singleton != null) {
                singleton.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public DialogManager createDialogManager(Context context, DialogOptions dialogOptions, StoreOptions storeOptions) {
            if (singleton == null || singleton.get() == null) {
                Class<DefaultDialogManager> clazz = DefaultDialogManager.class;
                synchronized (DefaultDialogManager.class) {
                    if (singleton == null || singleton.get() == null) {
                        void var3_4;
                        void var2_3;
                        if (singleton != null) {
                            singleton.clear();
                        }
                        singleton = new WeakReference<DefaultDialogManager>(new DefaultDialogManager(context, (DialogOptions)var2_3, (StoreOptions)var3_4));
                    } else {
                        ((DefaultDialogManager)singleton.get()).setContext(context);
                    }
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                }
            } else {
                void var1_1;
                ((DefaultDialogManager)singleton.get()).setContext((Context)var1_1);
            }
            return (DialogManager)singleton.get();
        }
    }
}

