/*
 * Decompiled with CFR 0.152.
 */
package com.vorlonsoft.android.rate;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vorlonsoft.android.rate.UriHelper;
import com.vorlonsoft.android.rate.Utils;
import java.util.Arrays;

final class IntentHelper {
    private static final String AMAZON_APPSTORE_PACKAGE_NAME = "com.amazon.venezia";
    private static final String BLACKBERRY_WORLD_PACKAGE_NAME = "net.rim.bb.appworld";
    private static final String CAFE_BAZAAR_PACKAGE_NAME = "com.farsitel.bazaar";
    private static final String GOOGLE_PLAY_PACKAGE_NAME = "com.android.vending";
    private static final String MI_PACKAGE_NAME = "com.xiaomi.market";
    private static final String SAMSUNG_GALAXY_APPS_PACKAGE_NAME = "com.sec.android.app.samsungapps";
    private static final String SLIDEME_MARKETPLACE_PACKAGE_NAME = "com.slideme.sam.manager";
    private static final String TENCENT_PACKAGE_NAME = "com.tencent.android.qqdownloader";
    private static final String YANDEX_STORE_PACKAGE_NAME = "com.yandex.store";
    private static final String[] BROWSERS_PACKAGES_NAMES = new String[]{"com.android.chrome", "org.mozilla.firefox", "com.opera.browser", "com.opera.mini.native", "com.sec.android.app.sbrowser", "com.UCMobile.intl", "com.tencent.mtt", "com.android.browser"};
    private static final String[] CHINESE_STORES_PACKAGES_NAMES = new String[]{"com.tencent.android.qqdownloader", "com.qihoo.appstore", "com.xiaomi.market", "com.huawei.appmarket", "com.baidu.appsearch", "com.oppo.market", "zte.com.market", "com.bbk.appstore", "com.wandoujia.phoenix2", "com.pp.assistant", "com.hiapk.marketpho", "com.dragon.android.pandaspace", "com.yingyonghui.market", "com.tencent.qqpimsecure", "com.mappn.gfan", "cn.goapk.market", "com.yulong.android.coolmart", "com.lenovo.leos.appstore", "com.coolapk.market"};

    private IntentHelper() {
        throw new AssertionError();
    }

    private static void setIntentForStore(Intent intent) {
        Intent intent2;
        intent.addFlags(0x10000000);
        intent.addFlags(0x200000);
        intent2.addFlags(0x4000000);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    static Intent[] createIntentsForStore(@NonNull Context context, int appStore, @NonNull String paramName) {
        Object[] intents;
        String[] storesPackagesNames;
        if (context == null || paramName == null) {
            return null;
        }
        boolean needStorePackage = false;
        boolean hasWebUriIntent = true;
        switch (appStore) {
            case 0: {
                storesPackagesNames = new String[]{AMAZON_APPSTORE_PACKAGE_NAME};
                break;
            }
            case 1: {
                storesPackagesNames = null;
                break;
            }
            case 2: {
                storesPackagesNames = new String[]{CAFE_BAZAAR_PACKAGE_NAME};
                break;
            }
            case 3: {
                storesPackagesNames = new String[]{BLACKBERRY_WORLD_PACKAGE_NAME};
                break;
            }
            case 4: {
                storesPackagesNames = CHINESE_STORES_PACKAGES_NAMES;
                needStorePackage = true;
                hasWebUriIntent = false;
                break;
            }
            case 6: {
                storesPackagesNames = new String[]{MI_PACKAGE_NAME};
                break;
            }
            case 7: {
                storesPackagesNames = new String[]{SAMSUNG_GALAXY_APPS_PACKAGE_NAME};
                needStorePackage = true;
                break;
            }
            case 8: {
                storesPackagesNames = new String[]{SLIDEME_MARKETPLACE_PACKAGE_NAME};
                break;
            }
            case 9: {
                storesPackagesNames = new String[]{TENCENT_PACKAGE_NAME};
                break;
            }
            case 10: {
                storesPackagesNames = new String[]{YANDEX_STORE_PACKAGE_NAME};
                needStorePackage = true;
                break;
            }
            default: {
                storesPackagesNames = new String[]{GOOGLE_PLAY_PACKAGE_NAME};
            }
        }
        String[] deviceStoresPackagesNames = storesPackagesNames == null ? null : Utils.isPackagesExists(context, storesPackagesNames);
        byte deviceStoresPackagesNumber = deviceStoresPackagesNames == null ? (byte)0 : (byte)deviceStoresPackagesNames.length;
        if ((byte)deviceStoresPackagesNumber > 0) {
            intents = hasWebUriIntent ? new Intent[deviceStoresPackagesNumber + 1] : new Intent[deviceStoresPackagesNumber];
            for (byte b = 0; b < deviceStoresPackagesNumber; b = (byte)((byte)(b + 1))) {
                intents[b] = new Intent("android.intent.action.VIEW", UriHelper.getStoreUri(appStore, paramName));
                IntentHelper.setIntentForStore((Intent)intents[b]);
                intents[b].setPackage(deviceStoresPackagesNames[b]);
            }
            if (hasWebUriIntent) {
                intents[var3_8] = new Intent("android.intent.action.VIEW", UriHelper.getStoreWebUri(appStore, paramName));
            }
        } else if (!needStorePackage) {
            String[] b;
            String[] deviceBrowsersPackagesNames;
            void var2_3;
            intents = new Intent[]{new Intent("android.intent.action.VIEW", UriHelper.getStoreWebUri(appStore, (String)var2_3))};
            if (appStore == 1 && (deviceBrowsersPackagesNames = Utils.isPackagesExists((Context)b, BROWSERS_PACKAGES_NAMES)) != null && deviceBrowsersPackagesNames.length > 0) {
                String[] stringArray;
                intents[0].setPackage(stringArray[0]);
            }
        } else {
            if (hasWebUriIntent) {
                Log.w((String)"ANDROIDRATE", (String)("Failed to rate app, " + Arrays.toString(intents) + " not exist on device and device can't start app store web (http/https) uri activity without it"));
            } else {
                void var1_2;
                Log.w((String)"ANDROIDRATE", (String)("Failed to rate app, " + Arrays.toString(intents) + " not exist on device and app store (" + (int)var1_2 + ") hasn't web (http/https) uri"));
            }
            return null;
        }
        return intents;
    }
}

