/*
 * Decompiled with CFR 0.152.
 */
package com.vorlonsoft.android.rate;

import android.content.Context;
import android.content.SharedPreferences;
import com.vorlonsoft.android.rate.AppInformation;
import java.util.Date;

final class PreferenceHelper {
    private static final String PREF_FILE_NAME = "androidrate_pref_file";
    private static final String PREF_KEY_365_DAY_PERIOD_DIALOG_LAUNCH_TIMES = "androidrate_365_day_period_dialog_launch_times";
    private static final String PREF_KEY_CUSTOM_EVENT_PREFIX = "androidrate_custom_event_prefix_";
    private static final String PREF_KEY_DIALOG_FIRST_LAUNCH_TIME = "androidrate_dialog_first_launch_time";
    private static final String PREF_KEY_INSTALL_DATE = "androidrate_install_date";
    private static final String PREF_KEY_IS_AGREE_SHOW_DIALOG = "androidrate_is_agree_show_dialog";
    private static final String PREF_KEY_LAUNCH_TIMES = "androidrate_launch_times";
    private static final String PREF_KEY_REMIND_INTERVAL = "androidrate_remind_interval";
    private static final String PREF_KEY_REMIND_LAUNCHES_NUMBER = "androidrate_remind_launches_number";
    private static final String PREF_KEY_VERSION_CODE = "androidrate_version_code";
    private static final String PREF_KEY_VERSION_NAME = "androidrate_version_name";

    private PreferenceHelper() {
        throw new AssertionError();
    }

    private static SharedPreferences getPreferences(Context context) {
        return context.getSharedPreferences(PREF_FILE_NAME, 0);
    }

    private static SharedPreferences.Editor getPreferencesEditor(Context context) {
        return PreferenceHelper.getPreferences(context).edit();
    }

    /*
     * WARNING - void declaration
     */
    private static void setCurrentDayDialogLaunchTimes(Context context, String dialogLaunchTimes, byte currentYear, short currentDay, short currentDayCount) {
        void var1_1;
        Context context2;
        void var2_2;
        void var3_3;
        if (currentYear > 1) {
            for (int b = 0; b < currentYear - 1; b = (int)((byte)(b + 1))) {
                dialogLaunchTimes = dialogLaunchTimes.replaceAll(":" + currentDay + "y" + b + "-[0-9][0-9]*:", ":");
            }
        }
        dialogLaunchTimes = dialogLaunchTimes.replaceAll(":" + currentDay + "y" + currentYear + "-[0-9][0-9]*:", ":" + (int)var3_3 + "y" + (int)var2_2 + "-" + currentDayCount + ":");
        PreferenceHelper.getPreferencesEditor(context2).putString(PREF_KEY_365_DAY_PERIOD_DIALOG_LAUNCH_TIMES, (String)var1_1).apply();
    }

    static void clearSharedPreferences(Context context) {
        PreferenceHelper.getPreferencesEditor(context).clear().apply();
    }

    static boolean isFirstLaunch(Context context) {
        return PreferenceHelper.getPreferences(context).getLong(PREF_KEY_INSTALL_DATE, 0L) == 0L;
    }

    static void setFirstLaunchSharedPreferences(Context context) {
        PreferenceHelper.getPreferencesEditor(context).putString(PREF_KEY_365_DAY_PERIOD_DIALOG_LAUNCH_TIMES, ":0y0-0:").putLong(PREF_KEY_DIALOG_FIRST_LAUNCH_TIME, 0L).putLong(PREF_KEY_INSTALL_DATE, new Date().getTime()).putInt(PREF_KEY_LAUNCH_TIMES, 1).putLong(PREF_KEY_REMIND_INTERVAL, 0L).putInt(PREF_KEY_REMIND_LAUNCHES_NUMBER, 0).putLong(PREF_KEY_VERSION_CODE, AppInformation.getInstance(context).getAppLongVersionCode()).putString(PREF_KEY_VERSION_NAME, AppInformation.getInstance(context).getAppVersionName()).apply();
        if (PreferenceHelper.getIsAgreeShowDialog(context)) {
            Context context2;
            PreferenceHelper.setIsAgreeShowDialog(context2, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void increment365DayPeriodDialogLaunchTimes(Context context) {
        void var1_1;
        void var2_2;
        void var3_3;
        Context context2;
        short currentDay = (short)((new Date().getTime() - PreferenceHelper.getDialogFirstLaunchTime(context)) / 86400000L);
        byte currentYear = (byte)(currentDay / 365);
        String currentDialogLaunchTimes = PreferenceHelper.getPreferences(context).getString(PREF_KEY_365_DAY_PERIOD_DIALOG_LAUNCH_TIMES, ":0y0-0:");
        if (currentYear > 0) {
            currentDay = (short)(currentDay % 365);
        }
        if (currentDialogLaunchTimes != null && currentDialogLaunchTimes.matches("(.*):" + currentDay + "y" + currentYear + "-[0-9][0-9]*:")) {
            short length = (short)currentDialogLaunchTimes.length();
            String currentDayCount = "" + currentDialogLaunchTimes.charAt(length - 2);
            for (short s = (short)(length - 3); s > 0 && Character.isDigit(currentDialogLaunchTimes.charAt(s)); s = (short)(s - 1)) {
                currentDayCount = currentDialogLaunchTimes.charAt(s) + currentDayCount;
            }
            PreferenceHelper.setCurrentDayDialogLaunchTimes(context, currentDialogLaunchTimes, currentYear, currentDay, (short)(Short.valueOf(currentDayCount) + 1));
            return;
        }
        PreferenceHelper.setCurrentDayDialogLaunchTimes(context2, (String)var3_3, (byte)var2_2, (short)var1_1, (short)1);
    }

    /*
     * WARNING - void declaration
     */
    static short get365DayPeriodDialogLaunchTimes(Context context) {
        void var1_1;
        Object object;
        short currentDay = (short)((new Date().getTime() - PreferenceHelper.getDialogFirstLaunchTime(context)) / 86400000L);
        byte currentYear = (byte)(currentDay / 365);
        Object dialogLaunchTimes = PreferenceHelper.getPreferences(context).getString(PREF_KEY_365_DAY_PERIOD_DIALOG_LAUNCH_TIMES, ":0y0-0:");
        String string2 = dialogLaunchTimes = dialogLaunchTimes != null ? ((String)dialogLaunchTimes).replaceAll(":[0-9][0-9]*y" + currentYear + "-", ":") : ":0y0-0:";
        if (currentYear > 0) {
            for (short s = (short)(currentDay % 365); s < 365; s = (short)(s + 1)) {
                dialogLaunchTimes = ((String)dialogLaunchTimes).replaceAll(":" + s + "y" + String.valueOf(currentYear - 1) + "-", ":");
            }
        }
        if (((String)(dialogLaunchTimes = ((String)dialogLaunchTimes).replaceAll(":[0-9][0-9]*y[0-9][0-9]*-[0-9][0-9]*:", ":"))).length() > 2) {
            dialogLaunchTimes = ((String)dialogLaunchTimes).substring(1, ((String)dialogLaunchTimes).length() - 1);
        }
        short dialogLaunchTimesCount = 0;
        for (String aDialogLaunchTimesSplit : ((String)object).split(":")) {
            dialogLaunchTimesCount = (short)(dialogLaunchTimesCount + Short.valueOf(aDialogLaunchTimesSplit));
        }
        return (short)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static void setCustomEventCount(Context context, String eventName, short eventCount) {
        void var2_2;
        void var1_1;
        PreferenceHelper.getPreferencesEditor(context).putInt(PREF_KEY_CUSTOM_EVENT_PREFIX.concat(String.valueOf(var1_1)), (int)var2_2).apply();
    }

    /*
     * WARNING - void declaration
     */
    static short getCustomEventCount(Context context, String eventName) {
        void var1_1;
        return (short)PreferenceHelper.getPreferences(context).getInt(PREF_KEY_CUSTOM_EVENT_PREFIX.concat(String.valueOf(var1_1)), 0);
    }

    static void setDialogFirstLaunchTime(Context context) {
        PreferenceHelper.getPreferencesEditor(context).putLong(PREF_KEY_DIALOG_FIRST_LAUNCH_TIME, new Date().getTime()).apply();
    }

    static long getDialogFirstLaunchTime(Context context) {
        return PreferenceHelper.getPreferences(context).getLong(PREF_KEY_DIALOG_FIRST_LAUNCH_TIME, 0L);
    }

    static long getInstallDate(Context context) {
        return PreferenceHelper.getPreferences(context).getLong(PREF_KEY_INSTALL_DATE, 0L);
    }

    /*
     * WARNING - void declaration
     */
    static void setIsAgreeShowDialog(Context context, boolean isAgree) {
        void var1_1;
        PreferenceHelper.getPreferencesEditor(context).putBoolean(PREF_KEY_IS_AGREE_SHOW_DIALOG, (boolean)var1_1).apply();
    }

    static boolean getIsAgreeShowDialog(Context context) {
        return PreferenceHelper.getPreferences(context).getBoolean(PREF_KEY_IS_AGREE_SHOW_DIALOG, true);
    }

    /*
     * WARNING - void declaration
     */
    static void setLaunchTimes(Context context, short launchTimes) {
        void var1_1;
        PreferenceHelper.getPreferencesEditor(context).putInt(PREF_KEY_LAUNCH_TIMES, (int)var1_1).apply();
    }

    static short getLaunchTimes(Context context) {
        return (short)PreferenceHelper.getPreferences(context).getInt(PREF_KEY_LAUNCH_TIMES, 0);
    }

    static void setRemindInterval(Context context) {
        PreferenceHelper.getPreferencesEditor(context).putLong(PREF_KEY_REMIND_INTERVAL, new Date().getTime()).apply();
    }

    static long getRemindInterval(Context context) {
        return PreferenceHelper.getPreferences(context).getLong(PREF_KEY_REMIND_INTERVAL, 0L);
    }

    static void setRemindLaunchesNumber(Context context) {
        Context context2;
        PreferenceHelper.getPreferencesEditor(context).putInt(PREF_KEY_REMIND_LAUNCHES_NUMBER, (int)PreferenceHelper.getLaunchTimes(context2)).apply();
    }

    static short getRemindLaunchesNumber(Context context) {
        return (short)PreferenceHelper.getPreferences(context).getInt(PREF_KEY_REMIND_LAUNCHES_NUMBER, 0);
    }

    static void clearRemindButtonClick(Context context) {
        PreferenceHelper.getPreferencesEditor(context).putLong(PREF_KEY_REMIND_INTERVAL, 0L).putInt(PREF_KEY_REMIND_LAUNCHES_NUMBER, 0).apply();
    }

    static void setVersionCode(Context context) {
        Context context2;
        PreferenceHelper.getPreferencesEditor(context).putLong(PREF_KEY_VERSION_CODE, AppInformation.getInstance(context2).getAppLongVersionCode()).apply();
    }

    static long getVersionCode(Context context) {
        return PreferenceHelper.getPreferences(context).getLong(PREF_KEY_VERSION_CODE, 0L);
    }

    static void setVersionName(Context context) {
        Context context2;
        PreferenceHelper.getPreferencesEditor(context).putString(PREF_KEY_VERSION_NAME, AppInformation.getInstance(context2).getAppVersionName()).apply();
    }

    static String getVersionName(Context context) {
        return PreferenceHelper.getPreferences(context).getString(PREF_KEY_VERSION_NAME, "");
    }
}

