package com.vungle.warren;

import java.util.concurrent.ExecutorService;

public class HeaderBiddingCallbackWrapper implements HeaderBiddingCallback {

    private final HeaderBiddingCallback callback;
    private final ExecutorService executorService;

    HeaderBiddingCallbackWrapper(ExecutorService executorService, HeaderBiddingCallback callback) {
        this.callback = callback;
        this.executorService = executorService;
    }

    @Override
    public void onBidTokenAvailable(final String placementId, final String bidToken) {
        if (callback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                callback.onBidTokenAvailable(placementId, bidToken);
            }
        });
    }

    @Override
    public void adAvailableForBidToken(final String placementId, final String bidToken) {
        if (callback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                callback.adAvailableForBidToken(placementId, bidToken);
            }
        });

    }
}
