package com.vungle.warren;

import com.vungle.warren.error.VungleException;

/**
 * Callback used when downloading advertisement assets for a given placement. This callback will be
 * notified of the download being completed or of any errors that prevented the SDK from downloading
 * the required assets.
 */
public interface LoadAdCallback {

    /**
     * Callback used to notify that the advertisement assets have been downloaded and are ready to
     * play.
     *
     * @param placementId The placement identifier for which the advertisement assets have been downloaded.
     */
    void onAdLoad(String placementId);

    /**
     * Callback used to notify that an error has occurred while downloading assets. This indicates
     * an unrecoverable error within the SDK, such as lack of network or out of disk space on the
     * device.
     *
     * @param placementId The identifier for the placement for which the error occurred.
     * @param exception   exception which will usually be an instance of {@link VungleException}
     *                    when the cause is known.
     */
    void onError(String placementId, VungleException exception);
}
