package com.vungle.warren;

import com.vungle.warren.error.VungleException;
import com.vungle.warren.utility.ThreadUtil;

import java.util.concurrent.ExecutorService;

class LoadAdCallbackWrapper implements LoadAdCallback {

    private final LoadAdCallback loadAdCallback;
    private final ExecutorService executorService;

    public LoadAdCallbackWrapper(ExecutorService executorService, LoadAdCallback loadAdCallback) {
        this.loadAdCallback = loadAdCallback;
        this.executorService = executorService;
    }

    @Override
    public void onAdLoad(final String placementId) {
        if (loadAdCallback == null) return;

        if (ThreadUtil.isMainThread()) {
            loadAdCallback.onAdLoad(placementId);
            return;
        }

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                loadAdCallback.onAdLoad(placementId);
            }
        });
    }

    @Override
    public void onError(final String placementId, final VungleException exception) {
        if (loadAdCallback == null) return;

        if (ThreadUtil.isMainThread()) {
            loadAdCallback.onError(placementId, exception);
            return;
        }

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                loadAdCallback.onError(placementId, exception);
            }
        });
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        LoadAdCallbackWrapper that = (LoadAdCallbackWrapper) o;

        if (loadAdCallback != null ? !loadAdCallback.equals(that.loadAdCallback) : that.loadAdCallback != null)
            return false;
        return executorService != null ? executorService.equals(that.executorService) : that.executorService == null;
    }

    @Override
    public int hashCode() {
        int result = loadAdCallback != null ? loadAdCallback.hashCode() : 0;
        result = 31 * result + (executorService != null ? executorService.hashCode() : 0);
        return result;
    }
}
