package com.vungle.warren;

import com.vungle.warren.model.Advertisement;

import java.util.concurrent.ExecutorService;

import androidx.annotation.Nullable;

class LoadNativeAdCallbackWrapper extends LoadAdCallbackWrapper implements LoadNativeAdCallback {

    private final LoadNativeAdCallback loadAdCallback;
    private final ExecutorService executorService;

    public LoadNativeAdCallbackWrapper(ExecutorService executorService, LoadNativeAdCallback loadAdCallback) {
        super(executorService, loadAdCallback);
        this.loadAdCallback = loadAdCallback;
        this.executorService = executorService;
    }

    @Override
    public void onAdLoad(@Nullable final Advertisement advertisement) {
        if (loadAdCallback == null) return;

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                loadAdCallback.onAdLoad(advertisement);
            }
        });
    }

}
