package com.vungle.warren;

import com.vungle.warren.error.VungleException;

public interface NativeAdListener {

    /**
     * Callback used to notify that the advertisement assets have been downloaded and are ready to
     * play.
     *
     * @param nativeAd The native ad used for render the native placement.
     */
    void onNativeAdLoaded(NativeAd nativeAd);

    /**
     * Callback used to notify that an error has occurred while downloading assets. This indicates
     * an unrecoverable error within the SDK, such as lack of network or out of disk space on the
     * device.
     *
     * @param placementId The identifier for the placement for which the error occurred.
     * @param exception   exception which will usually be an instance of {@link VungleException}
     *                    when the cause is known.
     */
    void onAdLoadError(String placementId, VungleException exception);

    /**
     * Callback for an error that has occurred while playing an advertisement. If this is called, the
     * error was unrecoverable by the SDK and error handling should happen at the application layer.
     * This indicates that the advertisement has finished.
     *
     * @param placementId The identifier for the advertisement placement for which the error occurred.
     * @param exception   The exception that prevented the advertisement from playing.
     */
    void onAdPlayError(String placementId, VungleException exception);

    /**
     * Called when the Vungle SDK has successfully launched the advertisement
     * and the advertisement is first rendered.
     *
     * @param placementId The Placement ID of the advertisement being played.
     */
    void onAdImpression(String placementId);

    /**
     * Callback for an advertisement tapped. Sent when the user has tapped on an ad.
     *
     * @param placementId The Placement ID of the advertisement that tapped.
     */
    void onAdClick(String placementId);

    /**
     * Callback when the user has left the app.
     *
     * @param placementId The Placement ID of the advertisement that tapped.
     */
    void onAdLeftApplication(String placementId);

    /**
     * Called when the ad is just acquired and its creative ID can be queried. The first callback
     * to be notified
     * @param creativeId The Creative Id of the advertisement
     */
    void creativeId(String creativeId);

}
