package com.vungle.warren;

import android.content.Context;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.vungle.warren.utility.ViewUtility;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

class NativeAdOptionsView extends FrameLayout {

    private static final int AD_OPTIONS_VIEW_SIZE = 20;

    private ImageView icon;

    public NativeAdOptionsView(@NonNull Context context) {
        super(context);
        initView(context);
    }

    public NativeAdOptionsView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        initView(context);
    }

    public NativeAdOptionsView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView(context);
    }

    private void initView(@NonNull Context context) {
        icon = new ImageView(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.WRAP_CONTENT,
                FrameLayout.LayoutParams.WRAP_CONTENT);
        params.gravity = Gravity.CENTER;
        icon.setLayoutParams(params);

        addView(icon);
    }

    public void renderTo(@NonNull NativeAd nativeAd, @NonNull FrameLayout rootView,
                         @AdConfig.AdOptionsPosition int optionsPosition) {
        if (getParent() != null) {
            ((ViewGroup) getParent()).removeView(this);
        }
        rootView.addView(this);

        String iconUrl = nativeAd.getPrivacyIconUrl();
        nativeAd.displayImage(iconUrl, icon);
        nativeAd.registerClickEvent(this, NativeAdLayout.ViewEvent.PRIVACY_CLICK);

        int size = ViewUtility.dpToPixels(getContext(), AD_OPTIONS_VIEW_SIZE);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(size, size);

        switch (optionsPosition) {
            case AdConfig.TOP_LEFT:
                params.gravity = Gravity.TOP | Gravity.START;
                break;
            case AdConfig.BOTTOM_LEFT:
                params.gravity = Gravity.BOTTOM | Gravity.START;
                break;
            case AdConfig.BOTTOM_RIGHT:
                params.gravity = Gravity.BOTTOM | Gravity.END;
                break;
            case AdConfig.TOP_RIGHT:
            default:
                params.gravity = Gravity.TOP | Gravity.END;
                break;
        }

        setLayoutParams(params);
        rootView.requestLayout();
    }

    public void destroy() {
        removeAllViews();
        if (getParent() != null) {
            ((ViewGroup) getParent()).removeView(this);
        }
    }
}
