package com.vungle.warren;

import com.vungle.warren.error.VungleException;
import com.vungle.warren.utility.ThreadUtil;

import java.util.concurrent.ExecutorService;

class PlayAdCallbackWrapper implements PlayAdCallback {

    private final PlayAdCallback playAdCallback;
    private final ExecutorService executorService;

    public PlayAdCallbackWrapper(ExecutorService executorService, PlayAdCallback playAdCallback) {
        this.playAdCallback = playAdCallback;
        this.executorService = executorService;
    }

    @Override
    public void creativeId(final String creativeId) {
        if (playAdCallback == null) return;

        if (ThreadUtil.isMainThread()) {
            playAdCallback.creativeId(creativeId);
            return;
        }

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.creativeId(creativeId);
            }
        });
    }

    @Override
    public void onAdStart(final String placementId) {
        if (playAdCallback == null) return;

        if (ThreadUtil.isMainThread()) {
            playAdCallback.onAdStart(placementId);
            return;
        }

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdStart(placementId);
            }
        });
    }

    @Override
    public void onAdEnd(final String placementId, final boolean completed, final boolean isCTAClicked) {
        if (playAdCallback == null) return;

        if (ThreadUtil.isMainThread()) {
            playAdCallback.onAdEnd(placementId, completed, isCTAClicked);
            return;
        }

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdEnd(placementId, completed, isCTAClicked);
            }
        });
    }

    @Override
    public void onAdEnd(final String placementId) {
        if (playAdCallback == null) return;

        if (ThreadUtil.isMainThread()) {
            playAdCallback.onAdEnd(placementId);
            return;
        }

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdEnd(placementId);
            }
        });
    }

    @Override
    public void onAdClick(final String placementId) {
        if (playAdCallback == null) return;

        if (ThreadUtil.isMainThread()) {
            playAdCallback.onAdClick(placementId);
            return;
        }

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdClick(placementId);
            }
        });
    }

    @Override
    public void onAdLeftApplication(final String placementId) {
        if (playAdCallback == null) return;

        if (ThreadUtil.isMainThread()) {
            playAdCallback.onAdLeftApplication(placementId);
            return;
        }

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdLeftApplication(placementId);
            }
        });
    }

    @Override
    public void onAdRewarded(final String placementId) {
        if (playAdCallback == null) return;

        if (ThreadUtil.isMainThread()) {
            playAdCallback.onAdRewarded(placementId);
            return;
        }

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdRewarded(placementId);
            }
        });
    }

    @Override
    public void onError(final String placementId, final VungleException exception) {
        if (playAdCallback == null) return;

        if (ThreadUtil.isMainThread()) {
            playAdCallback.onError(placementId, exception);
            return;
        }

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onError(placementId, exception);
            }
        });
    }

    @Override
    public void onAdViewed(final String placementId) {
        if (playAdCallback == null) return;

        if (ThreadUtil.isMainThread()) {
            playAdCallback.onAdViewed(placementId);
            return;
        }

        executorService.execute(new Runnable() {
            @Override
            public void run() {
                playAdCallback.onAdViewed(placementId);
            }
        });
    }
}
