package com.vungle.warren;

import android.util.Log;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Plugin {

    private static final String TAG = Plugin.class.getSimpleName();

    /**
     * Override the info passed from Vungle's Plugins and Adapters
     * This should NOT be used by any Publishers
     * This should be called before calling Vungle.init()
     */
    public static void addWrapperInfo(VungleApiClient.WrapperFramework wrapperFramework, String wrapperFrameworkVersion) {
        if (wrapperFramework != null && wrapperFramework != VungleApiClient.WrapperFramework.none) {
            VungleApiClient.WRAPPER_FRAMEWORK_SELECTED = wrapperFramework;
            String originalHeader = VungleApiClient.getHeaderUa();
            String wrapperVersion = wrapperFrameworkVersion != null && !wrapperFrameworkVersion.isEmpty() ? "/" + wrapperFrameworkVersion : "";
            String newMediation = wrapperFramework + wrapperVersion;
            String[] headers = originalHeader.split(";");
            Set set = new HashSet(Arrays.asList(headers));
            if (set.add(newMediation)) {
                VungleApiClient.setHeaderUa(originalHeader + ";" + newMediation);
            }
        } else {
            Log.e(TAG, "Wrapper is null or is none");
        }

        if (Vungle.isInitialized()) {
            Log.w(TAG, "VUNGLE WARNING: SDK already initialized, you should've set wrapper info before");
        }
    }
}
