package com.vungle.warren;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.Pair;

import com.vungle.warren.error.VungleException;
import com.vungle.warren.ui.CloseDelegate;
import com.vungle.warren.ui.OrientationDelegate;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.contract.NativeAdContract;
import com.vungle.warren.ui.contract.WebAdContract.WebAdPresenter;
import com.vungle.warren.ui.state.OptionsState;
import com.vungle.warren.ui.view.FullAdWidget;
import com.vungle.warren.ui.view.VungleWebClient;

public interface PresentationFactory {

    void getFullScreenPresentation(@NonNull Context context,
                                   @NonNull AdRequest request,
                                   @NonNull FullAdWidget fullAdWidget,
                                   @Nullable OptionsState optionsState,
                                   @NonNull final CloseDelegate closeDelegate,
                                   @NonNull final OrientationDelegate orientationDelegate,
                                   @Nullable Bundle savedState,
                                   @NonNull FullScreenCallback fullscreenCallback);

    void getBannerViewPresentation(Context context,
                                   @NonNull AdRequest request,
                                   @Nullable AdConfig adConfig,
                                   @NonNull CloseDelegate closeDelegate,
                                   @NonNull ViewCallback viewCallback);

    void getNativeViewPresentation(@NonNull final Context context,
                                   @NonNull final NativeAdLayout nativeAdLayout,
                                   @NonNull AdRequest request,
                                   @Nullable AdConfig adConfig,
                                   @NonNull NativeViewCallback viewCallback);

    void saveState(Bundle bundle);

    void destroy();

    interface FullScreenCallback {
        void onResult(@NonNull Pair<AdContract.AdView, AdContract.AdvertisementPresenter> result, @Nullable VungleException error);
    }

    interface NativeViewCallback {
        void onResult(@NonNull Pair<NativeAdContract.NativeView, NativeAdContract.NativePresenter> result, @Nullable VungleException error);
    }

    interface ViewCallback {
        /**
         * @param result {@link WebAdPresenter} appropriate for the type of currentAdvertisement
         *               being played for this placement.
         * @param error  {@link VungleException} In case the placement identifier is invalid, or no
         *               presenter for the currentAdvertisement has been
         *               designated.
         */
        void onResult(@NonNull Pair<WebAdPresenter, VungleWebClient> result, @Nullable VungleException  error);
    }
}
