package com.vungle.warren.analytics;

import androidx.annotation.NonNull;

import com.google.gson.JsonObject;
import com.vungle.warren.tasks.AnalyticsJob;
import com.vungle.warren.tasks.JobInfo;
import com.vungle.warren.tasks.JobRunner;

public class JobDelegateAnalytics implements AdAnalytics {

    private final JobRunner jobRunner;

    public JobDelegateAnalytics(JobRunner jobRunner) {
        this.jobRunner = jobRunner;
    }

    @Override
    public String[] ping(@NonNull String[] urls) {
        jobRunner.execute(AnalyticsJob.makeJob(AnalyticsJob.Action.STORE_URL, null, urls, JobInfo.NetworkType.ANY));
        jobRunner.execute(AnalyticsJob.makeJob(AnalyticsJob.Action.PING, null, urls, JobInfo.NetworkType.CONNECTED));
        return new String[]{};
    }

    @Override
    public void ri(JsonObject body) {
        jobRunner.execute(AnalyticsJob.makeJob(AnalyticsJob.Action.RI, body.toString(), null, JobInfo.NetworkType.CONNECTED));
    }

    @Override
    public String[] retryUnsent() {
        jobRunner.execute(AnalyticsJob.makeJob(AnalyticsJob.Action.RETRY_UNSENT, null, null, JobInfo.NetworkType.CONNECTED));
        return new String[]{};
    }

    @Override
    public void saveVungleUrls(String[] urls) {
        //unused
    }
}
